% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_range.R
\docType{data}
\name{st_z_range}
\alias{st_z_range}
\alias{is.na.z_range}
\alias{st_z_range.POINT}
\alias{st_z_range.MULTIPOINT}
\alias{st_z_range.LINESTRING}
\alias{st_z_range.POLYGON}
\alias{st_z_range.MULTILINESTRING}
\alias{st_z_range.MULTIPOLYGON}
\alias{st_z_range.GEOMETRYCOLLECTION}
\alias{st_z_range.MULTISURFACE}
\alias{st_z_range.MULTICURVE}
\alias{st_z_range.CURVEPOLYGON}
\alias{st_z_range.COMPOUNDCURVE}
\alias{st_z_range.POLYHEDRALSURFACE}
\alias{st_z_range.TIN}
\alias{st_z_range.TRIANGLE}
\alias{st_z_range.CIRCULARSTRING}
\alias{st_z_range.sfc}
\alias{st_z_range.sf}
\alias{st_z_range.numeric}
\alias{NA_z_range_}
\title{Return 'z' range of a simple feature or simple feature set}
\format{An object of class \code{z_range} of length 2.}
\usage{
\method{is.na}{z_range}(x)

st_z_range(obj, ...)

\method{st_z_range}{POINT}(obj, ...)

\method{st_z_range}{MULTIPOINT}(obj, ...)

\method{st_z_range}{LINESTRING}(obj, ...)

\method{st_z_range}{POLYGON}(obj, ...)

\method{st_z_range}{MULTILINESTRING}(obj, ...)

\method{st_z_range}{MULTIPOLYGON}(obj, ...)

\method{st_z_range}{GEOMETRYCOLLECTION}(obj, ...)

\method{st_z_range}{MULTISURFACE}(obj, ...)

\method{st_z_range}{MULTICURVE}(obj, ...)

\method{st_z_range}{CURVEPOLYGON}(obj, ...)

\method{st_z_range}{COMPOUNDCURVE}(obj, ...)

\method{st_z_range}{POLYHEDRALSURFACE}(obj, ...)

\method{st_z_range}{TIN}(obj, ...)

\method{st_z_range}{TRIANGLE}(obj, ...)

\method{st_z_range}{CIRCULARSTRING}(obj, ...)

\method{st_z_range}{sfc}(obj, ...)

\method{st_z_range}{sf}(obj, ...)

\method{st_z_range}{numeric}(obj, ..., crs = NA_crs_)

NA_z_range_
}
\arguments{
\item{x}{object of class \code{z_range}}

\item{obj}{object to compute the z range from}

\item{...}{ignored}

\item{crs}{object of class \code{crs}, or argument to \link{st_crs}, specifying the CRS of this bounding box.}
}
\value{
a numeric vector of length two, with \code{zmin} and \code{zmax} values;
if \code{obj} is of class \code{sf} or \code{sfc} the object
returned has a class \code{z_range}
}
\description{
Return 'z' range of a simple feature or simple feature set
}
\details{
\code{NA_z_range_} represents the missing value for a \code{z_range} object
}
\examples{
a = st_sf(a = 1:2, geom = st_sfc(st_point(0:2), st_point(1:3)), crs = 4326)
st_z_range(a)
st_z_range(c(zmin = 16.1, zmax = 16.6), crs = st_crs(4326))
}
\keyword{datasets}
