% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{st_write}
\alias{st_write}
\alias{st_write.sfc}
\alias{st_write.sf}
\alias{st_write.data.frame}
\alias{write_sf}
\alias{st_delete}
\title{Write simple features object to file or database}
\usage{
st_write(obj, dsn, layer, ...)

\method{st_write}{sfc}(obj, dsn, layer, ...)

\method{st_write}{sf}(
  obj,
  dsn,
  layer = NULL,
  ...,
  driver = guess_driver_can_write(dsn),
  dataset_options = NULL,
  layer_options = NULL,
  quiet = FALSE,
  factorsAsCharacter = TRUE,
  append = NA,
  delete_dsn = FALSE,
  delete_layer = !is.na(append) && !append,
  fid_column_name = NULL,
  config_options = character(0)
)

\method{st_write}{data.frame}(obj, dsn, layer = NULL, ...)

write_sf(..., quiet = TRUE, append = FALSE, delete_layer = !append)

st_delete(
  dsn,
  layer = character(0),
  driver = guess_driver_can_write(dsn),
  quiet = FALSE
)
}
\arguments{
\item{obj}{object of class \code{sf} or \code{sfc}}

\item{dsn}{data source name. Interpretation varies by driver: can be
a filename, a folder, a database name, or a Database Connection
(we officially test support for
\code{\link[RPostgres:Postgres]{RPostgres::Postgres()}} connections).}

\item{layer}{layer name. Varies by driver, may be a file name without
extension; for database connection, it is the name of the table. If layer
is missing, the \code{basename} of \code{dsn} is taken.}

\item{...}{other arguments passed to \link{dbWriteTable} when \code{dsn} is a
Database Connection}

\item{driver}{character; name of driver to be used; if missing and \code{dsn} is not a Database Connection, a driver name is guessed from \code{dsn};
\code{st_drivers()} returns the drivers that are available with their properties; links to full driver documentation
are found at \url{https://gdal.org/drivers/vector/index.html}}

\item{dataset_options}{character; driver dependent dataset creation options;
multiple options supported.}

\item{layer_options}{character; driver dependent layer creation options;
multiple options supported.}

\item{quiet}{logical; suppress info on name, driver, size and spatial
reference}

\item{factorsAsCharacter}{logical; convert \code{factor} levels to character
strings (\code{TRUE}, default), otherwise into numbers when
factorsAsCharacter is \code{FALSE}. For database connections,
\code{factorsAsCharacter} is always \code{TRUE}.}

\item{append}{logical; should we append to an existing layer, or replace it?
if \code{TRUE} append, if \code{FALSE} replace.
The default for \code{st_write} is \code{NA} which raises an error if the layer exists.
The default for \code{write_sf} is \code{FALSE}, which overwrites any existing data.
See also next two arguments for more control on overwrite behavior.}

\item{delete_dsn}{logical; delete data source \code{dsn} before attempting
to write?}

\item{delete_layer}{logical; delete layer \code{layer} before attempting to
write?
The default for \code{st_write} is \code{FALSE} which raises an error if the layer exists.
The default for \code{write_sf} is \code{TRUE}.}

\item{fid_column_name}{character, name of column with feature IDs; if
specified, this column is no longer written as feature attribute.}

\item{config_options}{character, named vector with GDAL config options}
}
\value{
\code{obj}, invisibly
}
\description{
Write simple features object to file or database
}
\details{
Columns (variables) of a class not supported are dropped with a warning.

When updating an existing layer, records are appended to it if the updating
object has the right variable names and types. If names don't match an
error is raised. If types don't match, behaviour is undefined: GDAL may
raise warnings or errors or fail silently.

When deleting layers or data sources is not successful, no error is emitted.
\code{delete_dsn} and \code{delete_layer} should be
handled with care; the former may erase complete directories or databases.

st_delete deletes layer(s) in a data source, or a data source if layers are 
omitted; it returns TRUE on success, FALSE on failure, invisibly.
}
\examples{
nc = st_read(system.file("shape/nc.shp", package="sf"))
st_write(nc, paste0(tempdir(), "/", "nc.shp"))
st_write(nc, paste0(tempdir(), "/", "nc.shp"), delete_layer = TRUE) # overwrites
if (require(sp, quietly = TRUE)) {
 data(meuse, package = "sp") # loads data.frame from sp
 meuse_sf = st_as_sf(meuse, coords = c("x", "y"), crs = 28992)
 # writes X and Y as columns:
 st_write(meuse_sf, paste0(tempdir(), "/", "meuse.csv"), layer_options = "GEOMETRY=AS_XY")
 st_write(meuse_sf, paste0(tempdir(), "/", "meuse.csv"), layer_options = "GEOMETRY=AS_WKT",
   delete_dsn=TRUE) # overwrites
\dontrun{
 library(sp)
 example(meuse, ask = FALSE, echo = FALSE)
 try(st_write(st_as_sf(meuse), "PG:dbname=postgis", "meuse_sf",
     layer_options = c("OVERWRITE=yes", "LAUNDER=true")))
 demo(nc, ask = FALSE)
 try(st_write(nc, "PG:dbname=postgis", "sids", layer_options = "OVERWRITE=true"))
}
}
}
\seealso{
\link{st_drivers}, \link{dbWriteTable}
}
