% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R, R/sfc.R, R/wkb.R, R/wkt.R, R/sp.R,
%   R/maps.R, R/s2.R
\name{st_as_sfc}
\alias{st_as_sfc}
\alias{st_as_sfc.pq_geometry}
\alias{st_as_sfc.list}
\alias{st_as_sfc.blob}
\alias{st_as_sfc.bbox}
\alias{st_as_sfc.WKB}
\alias{st_as_sfc.raw}
\alias{st_as_sfc.character}
\alias{st_as_sfc.factor}
\alias{st_as_sfc.SpatialPoints}
\alias{st_as_sfc.SpatialPixels}
\alias{st_as_sfc.SpatialMultiPoints}
\alias{st_as_sfc.SpatialLines}
\alias{st_as_sfc.SpatialPolygons}
\alias{st_as_sfc.map}
\alias{st_as_sfc.s2_geography}
\title{Convert foreign geometry object to an sfc object}
\usage{
\method{st_as_sfc}{pq_geometry}(
  x,
  ...,
  EWKB = TRUE,
  spatialite = FALSE,
  pureR = FALSE,
  crs = NA_crs_
)

\method{st_as_sfc}{list}(x, ..., crs = NA_crs_)

\method{st_as_sfc}{blob}(x, ...)

\method{st_as_sfc}{bbox}(x, ...)

\method{st_as_sfc}{WKB}(
  x,
  ...,
  EWKB = FALSE,
  spatialite = FALSE,
  pureR = FALSE,
  crs = NA_crs_
)

\method{st_as_sfc}{raw}(x, ...)

\method{st_as_sfc}{character}(x, crs = NA_integer_, ..., GeoJSON = FALSE)

\method{st_as_sfc}{factor}(x, ...)

st_as_sfc(x, ...)

\method{st_as_sfc}{SpatialPoints}(x, ..., precision = 0)

\method{st_as_sfc}{SpatialPixels}(x, ..., precision = 0)

\method{st_as_sfc}{SpatialMultiPoints}(x, ..., precision = 0)

\method{st_as_sfc}{SpatialLines}(x, ..., precision = 0, forceMulti = FALSE)

\method{st_as_sfc}{SpatialPolygons}(x, ..., precision = 0, forceMulti = FALSE)

\method{st_as_sfc}{map}(x, ...)

\method{st_as_sfc}{s2_geography}(
  x,
  ...,
  crs = st_crs(4326),
  endian = match(.Platform$endian, c("big", "little")) - 1L
)
}
\arguments{
\item{x}{object to convert}

\item{...}{further arguments}

\item{EWKB}{logical; if \code{TRUE}, parse as EWKB (extended WKB; PostGIS: ST_AsEWKB), otherwise as ISO WKB (PostGIS: ST_AsBinary)}

\item{spatialite}{logical; if \code{TRUE}, WKB is assumed to be in the spatialite dialect, see \url{https://www.gaia-gis.it/gaia-sins/BLOB-Geometry.html}; this is only supported in native endian-ness (i.e., files written on system with the same endian-ness as that on which it is being read).}

\item{pureR}{logical; if \code{TRUE}, use only R code, if \code{FALSE}, use compiled (C++) code; use \code{TRUE} when the endian-ness of the binary differs from the host machine (\code{.Platform$endian}).}

\item{crs}{coordinate reference system to be assigned; object of class \code{crs}}

\item{GeoJSON}{logical; if \code{TRUE}, try to read geometries from GeoJSON text strings
geometry, see \code{\link[=st_crs]{st_crs()}}}

\item{precision}{precision value; see \link{st_as_binary}}

\item{forceMulti}{logical; if \code{TRUE}, force coercion into \code{MULTIPOLYGON} or \code{MULTILINE} objects, else autodetect}

\item{endian}{integer; 0 or 1: defaults to the endian of the native machine}
}
\description{
Convert foreign geometry object to an sfc object
}
\details{
When converting from WKB, the object \code{x} is either a character vector such as typically obtained from PostGIS (either with leading "0x" or without), or a list with raw vectors representing the features in binary (raw) form.

If \code{x} is a character vector, it should be a vector containing
\href{https://www.ogc.org/standard/wkt-crs/}{well-known-text}, or
Postgis EWKT or GeoJSON representations of a single geometry for each vector element.

If \code{x} is a \code{factor}, it is converted to \code{character}.
}
\examples{
wkb = structure(list("01010000204071000000000000801A064100000000AC5C1441"), class = "WKB")
st_as_sfc(wkb, EWKB = TRUE)
wkb = structure(list("0x01010000204071000000000000801A064100000000AC5C1441"), class = "WKB")
st_as_sfc(wkb, EWKB = TRUE)
st_as_sfc(st_as_binary(st_sfc(st_point(0:1)))[[1]], crs = 4326)
st_as_sfc("SRID=3978;LINESTRING(1663106 -105415,1664320 -104617)")
}
