% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emerging-hostpot-analysis.R
\name{emerging_hotspot_analysis}
\alias{emerging_hotspot_analysis}
\title{Emerging Hot Spot Analysis}
\usage{
emerging_hotspot_analysis(
  x,
  .var,
  k = 1,
  include_gi = FALSE,
  nb_col = NULL,
  wt_col = NULL,
  nsim = 199,
  threshold = 0.01,
  ...
)
}
\arguments{
\item{x}{a spacetime object and must be a spacetime cube see details for more.}

\item{.var}{a numeric vector in the spacetime cube with no missing values.}

\item{k}{default \code{1}. The number of time lags to include in the neighborhood
for calculating the local Gi*. See details for more.}

\item{include_gi}{default \code{FALSE}. If \code{TRUE}, includes the local Gi* calculations
in the attribute \code{gi_star}.}

\item{nb_col}{Optional. Default \code{NULL}. The name of the column in the \code{geometry}
context of \code{x} containing spatial neighbors. If \code{NULL}, Queen's contiguity
neighbors are identified.}

\item{wt_col}{Optional. Default \code{NULL}. The name of the column in the \code{geometry}
context of \code{x} containing spatial weights. If \code{NULL}, row standardized weights
are used.}

\item{nsim}{default \code{199}. The number of simulations to run in calculating the
simulated p-value for the local Gi*.}

\item{threshold}{default \code{0.01}. The significance threshold to use.}

\item{...}{unused.}
}
\value{
Returns a data.frame.
}
\description{
Emerging Hot Spot Analysis identifies trends in spatial clustering over a
period of time. Emerging hot spot analysis combines the Getis-Ord Gi* statistic
with the Mann-Kendall trend test to determine if there is a temporal trend
associated with local clustering of hot and cold spots.
}
\details{
\subsection{How Emerging Hot Spot Analysis Works}{

Emerging Hot Spot Analysis is a somewhat simple process. It works by first
calculating the Gi* statistic for each location in each time period (time-slice).
Next, for each location across all time-periods, the Mann-Kendall trend test
is done to identify any temporal trend in Gi* values over all time periods.
Additionally, each location is classified into one of seventeen categories based
on \href{https://pro.arcgis.com/en/pro-app/2.8/tool-reference/space-time-pattern-mining/learnmoreemerging.htm}{ESRI's emerging hot spot classification criteria}.

The Mann-Kendall trend test is done using \code{\link[Kendall:MannKendall]{Kendall::MannKendall()}}. \code{Kendall}
is not installed with sfdep and should be installed prior to use.
}

\subsection{Using your own neighbors and weights}{

If you would like to use your own neighbors and weights, they must be created
in the \code{geometry} context of a spacetime object. The arguments \code{nb_col}
and \code{wt_col} must both be populated in order to use your own neighbor and weights
definitions.
}

\subsection{Time lagged neighbors}{

In addition to identifying neighbors in space, emerging hotspot analysis also
incorporates the same observations from \code{k} periods ago-called a time lag. If
the time lag k is 1 and the unit of time is month, the neighbors for the
calculation of Gi* would include the spatial neighbors' values at time \code{t}
and the same spatial neighbors' values at time \code{t-1}. If \code{k = 2}, it would include
\code{t}, \code{t-1}, and \code{t-2}.
}

\subsection{Missing values}{

Presently, there is no method of missing value handling. If there are missing
values, the emerging hot spot analysis will fail. Be sure to fill or omit
time-slices with missing values \emph{prior} to using emerging hot spot analysis.
}
}
\examples{
df_fp <- system.file("extdata", "bos-ecometric.csv", package = "sfdep")
geo_fp <- system.file("extdata", "bos-ecometric.geojson", package = "sfdep")

# read in data
df <- readr::read_csv(df_fp, col_types = "ccidD")
geo <- sf::read_sf(geo_fp)

# Create spacetime object called `bos`
bos <- spacetime(df, geo,
                 .loc_col = ".region_id",
                 .time_col = "time_period")


# conduct EHSA
ehsa <- emerging_hotspot_analysis(
  x = bos,
  .var = "value",
  k = 1,
  nsim = 9
)

ehsa
}
\seealso{
\href{https://pro.arcgis.com/en/pro-app/2.8/tool-reference/space-time-pattern-mining/learnmoreemerging.htm}{How Emerging Hot Spot Analysis works}, \href{https://pro.arcgis.com/en/pro-app/2.8/tool-reference/space-time-pattern-mining/emerginghotspots.htm}{Emerging Hot Spot Analysis (Space Time Pattern Mining)}, and the video \href{https://www.youtube.com/watch?v=0aV6HHwJuo4&t=3848s&ab_channel=EsriEvents}{Spatial Data Mining II: A Deep Dive into Space-Time Analysis} by ESRI.
}
