% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfinxMain.R
\name{sfinx}
\alias{sfinx}
\title{SFINX (Straightforward Filtering INdeX).}
\usage{
sfinx(InputData, BaitVector, BackgroundRatio = 5,
  BackgroundIdentity = "automatic", BaitInfluence = FALSE,
  ConstantLimit = FALSE, FWERType = "B")
}
\arguments{
\item{InputData}{A strictly numeric matrix with unique proteins as rownames
and unique projects as colnames. The cells of the matrix are filled with
the associated \strong{peptide counts}. Cells that have no associated
peptide counts have to be filled with a zero.}

\item{BaitVector}{A character vector with all the bait proteins of
interest. These proteins should all be present as the exact same
rownames in \code{InputData}. \code{sfinx} will control this, and it will
report possible deviations.}

\item{BackgroundRatio}{Advanced. A natural number equal or bigger than 2,
that specifies the maximal ratio of total considered projects over the
amount of bait projects. If this parameter equals for example 5, it will
take into account 4 times as much non-bait projects as it uses bait
projects. \code{sfinx} will preferably first select the non-bait projects
with most peptide counts as negative controls.}

\item{BackgroundIdentity}{Deprecated. A character string or character
vector describing the background projects. \code{"automatic"} is the
advised default entry. However, all extra or alternative entries will be
matched to the column headers and taken into account when possible.}

\item{BaitInfluence}{Advanced. A logical. When TRUE, \code{sfinx} uses only
the non-bait negative control projects with the biggest amount of data for
the calculation of the background, but no negative control projects
associated with other baits in the analysis. When FALSE, \code{sfinx} uses
both.}

\item{ConstantLimit}{Advanced. A logical. When TRUE, an internal cut-off is
used that is a simplified constant for the actual complete calculation of
the binomial equivalent. This is the version of \code{sfinx} that was used
in the article (Titeca et al., J. Proteome Res., 2016). When FALSE, the
complete calculation of the binomial equivalent is done. Some datasets with
many highly abundant proteins can benefit from having this parameter FALSE.}

\item{FWERType}{Advanced. A character string that equals \code{"B"},
\code{"HolmB"} or \code{"Sidak"}. \code{"B"} gives the Bonferroni correction
for the family wise error rate (FWER), \code{"HolmB"} gives Holm-Bonferroni
correction, and \code{"Sidak"} gives Sidak correction. However, note that
these options will only very rarely yield different output.}
}
\value{
\code{sfinx} returns a list with two elements. The first element of
the list contains a dataframe with the true-positive protein interactions
that were identified by \code{sfinx} in \code{InputData} for the proteins of
interest in \code{BaitVector}. The second element of the list contains a
string with comments about the output and the underlying data.
}
\description{
\code{sfinx} identifies the true-positive protein interactions
in affinity purification - mass spectrometry data sets and in similar
co-complex interactomics data sets. It is highly accurate, fast and
independent of external data input.

It is also available via the Web interface at \url{http://sfinx.ugent.be},
which has extra analysis and visualization features.
}
\details{
For most standard applications of \code{sfinx}, the arguments
\code{InputData} and \code{BaitVector} should be sufficient. Any
optimization of the other parameters is discouraged and should be explicitly
reported upon communication of the results.
}
\examples{
sfinx(DataInputExampleFile, BaitIdentityExampleFile)

sfinx(InputData = DataInputExampleFile, BaitVector =
BaitIdentityExampleFile, ConstantLimit = TRUE, FWERType = "Sidak")


}

