% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_varimp.R
\name{plot_varimp}
\alias{plot_varimp}
\title{Variable importance bar plot of a sparse group boosting model}
\usage{
plot_varimp(
  sgb_model,
  prop = 0,
  n_predictors = 30,
  max_char_length = 15,
  base_size = 8
)
}
\arguments{
\item{sgb_model}{Model of type \code{mboost} to plot the variable importance.}

\item{prop}{Numeric value indicating the minimal importance a predictor/baselearner has to have.
Default value is zero, meaning all predictors are plotted. By increasing prop the number of
plotted variables can be reduced. One can also use \code{'n_predictors'} for limiting
the number of variables to be plotted directly.}

\item{n_predictors}{The maximum number of predictors to be plotted. Default is 30.
Alternative to \code{'prop'}.}

\item{max_char_length}{The maximum character length of a predictor to be printed.
Default is 15. For larger groups or long variable names one may adjust this number to
differentiate variables from groups.}

\item{base_size}{The \code{base_size} argument to be passed to the \code{ggplot2} theme
\link[ggplot2:ggtheme]{ggplot2::theme_bw} to be used to control the overall size of the figure.
Default value is 8.}
}
\value{
object of type \code{ggplot2}.
}
\description{
Visualizes the variable importance of a sparse-group boosting model.
Color indicates if a predictor is an individual variable or a group.
}
\details{
Note that aggregated group and individual variable importance printed in the legend is based
only on the plotted variables and not on all variables that were selected in the sparse-group
boosting model.
}
\examples{
library(mboost)
library(dplyr)
set.seed(1)
df <- data.frame(
  x1 = rnorm(100), x2 = rnorm(100), x3 = rnorm(100),
  x4 = rnorm(100), x5 = runif(100)
)
df <- df \%>\%
  mutate_all(function(x) {
    as.numeric(scale(x))
  })
df$y <- df$x1 + df$x4 + df$x5
group_df <- data.frame(
  group_name = c(1, 1, 1, 2, 2),
  var_name = c("x1", "x2", "x3", "x4", "x5")
)

sgb_formula <- as.formula(create_formula(alpha = 0.3, group_df = group_df))
sgb_model <- mboost(formula = sgb_formula, data = df)
sgb_varimp <- plot_varimp(sgb_model)
}
\seealso{
\link{get_varimp} which this function uses.
}
