% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_varimp.R
\name{get_varimp}
\alias{get_varimp}
\title{Variable importance of a sparse-group boosting model}
\usage{
get_varimp(sgb_model)
}
\arguments{
\item{sgb_model}{Model of type \code{mboost} to compute the variable importance for.}
}
\value{
List of two data.frames. \verb{$raw} contains the name of the variables, group structure and
variable importance on both group and individual variable basis.
\verb{$group_importance} contains the the aggregated relative importance of all
group baselearners and of all individual variables.
}
\description{
Variable importance is computed as relative reduction of loss-function attributed
to each predictor (groups and individual variables).
Returns a list of two data.frames. The first contains the variable importance
of a sparse-group model in a data.frame for each predictor.
The second one contains the aggregated relative importance of all groups vs. individual variables.
}
\examples{
library(mboost)
library(dplyr)
set.seed(1)
df <- data.frame(
  x1 = rnorm(100), x2 = rnorm(100), x3 = rnorm(100),
  x4 = rnorm(100), x5 = runif(100)
)
df <- df \%>\%
  mutate_all(function(x) {
    as.numeric(scale(x))
  })
df$y <- df$x1 + df$x4 + df$x5
group_df <- data.frame(
  group_name = c(1, 1, 1, 2, 2),
  var_name = c("x1", "x2", "x3", "x4", "x5")
)

sgb_formula <- as.formula(create_formula(alpha = 0.3, group_df = group_df))
sgb_model <- mboost(formula = sgb_formula, data = df)
sgb_varimp <- get_varimp(sgb_model)
}
\seealso{
\code{\link[mboost:varimp]{mboost::varimp()}} which this function uses.
}
