% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initGMF-class.R
\name{fitted.initgmf}
\alias{fitted.initgmf}
\title{Extract the fitted values of an initialized GMF model}
\usage{
\method{fitted}{initgmf}(object, ..., type = c("link", "response", "terms"), partial = FALSE)
}
\arguments{
\item{object}{an object of class \code{initgmf}}

\item{...}{further arguments passed to or from other methods}

\item{type}{the type of fitted values which should be returned}

\item{partial}{if \code{TRUE}, returns the partial fitted values}
}
\value{
If \code{type="terms"}, a list of fitted values containing the fields \code{XB},
\code{AZ} and \code{UV}. Otherwise, a matrix of fitted values in the link or
response scale, depending on the selected \code{type}.
}
\description{
Computes the fitted values of an initialized GMF model.
}
\examples{
# Load the sgdGMF package
library(sgdGMF)

# Generate data from a Poisson model
data = sim.gmf.data(n = 100, m = 20, ncomp = 5, family = poisson())

# Fit a GMF model with 3 latent factors
init = sgdgmf.init(data$Y, ncomp = 3, family = poisson())

# Get the fitted values of a GMF model
str(fitted(init)) # returns the overall fitted values in link scale
str(fitted(init, type = "response")) # returns the overall fitted values in response scale
str(fitted(init, partial = TRUE)) # returns the partial fitted values in link scale

}
\seealso{
\code{\link{fitted.sgdgmf}}.
}
