% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{set.control.alg}
\alias{set.control.alg}
\title{Check and set the control parameters for the select optimization algorithm}
\usage{
set.control.alg(
  method = c("airwls", "newton", "sgd"),
  sampling = c("block", "coord", "rnd-block"),
  control = list()
)
}
\arguments{
\item{method}{optimization method to use}

\item{sampling}{sub-sampling method to use}

\item{control}{list of algorithm-specific control parameters}
}
\value{
A \code{list} of control parameters for the selected estimation algorithm
}
\description{
Check if the input control parameters are allowed and set them to default
values if they are not. Returns a list of well-defined control parameters.
}
\details{
It is not necessary to provide a complete list of control parameters, one can
just specify a list containing the parameters he/she needs to change from the
default values. Wrongly specified parameters are ignored or set to default values.
For a detailed description of all the algorithm-specific control parameters,
please refer to
\code{\link{set.control.airwls}} (\code{method="airwls"}),
\code{\link{set.control.newton}} (\code{method="newton"}),
\code{\link{set.control.block.sgd}} (\code{method="sgd"}, \code{sampling="block"}).
\code{\link{set.control.coord.sgd}} (\code{method="sgd"}, \code{sampling="coord"}),
}
\examples{
library(sgdGMF)

# Empty call
set.control.alg()

# Parametrized call
set.control.alg(method = "airwls", control = list(maxiter = 200, stepsize = 0.3))


}
\seealso{
\code{\link{set.control.init}}, \code{\link{set.control.cv}}, \code{\link{sgdgmf.fit}}
}
