% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gu.R
\name{Gu}
\alias{Gu}
\title{Tool to build the basis matrix and the penalty matrix of natural cubic splines.}
\usage{
Gu(t, knot)
}
\arguments{
\item{t}{the covariate.}

\item{knot}{a integer value that represent the number of knots of the natural cubic spline.}
}
\value{
nknot number of knots.

knots set of knots.

N  basis matrix.

K penalty matrix.
}
\description{
\code{Gu} builds the basis matrix and penalty matrix to approximate a smooth function using
natural cubic splines based on the Gu basis form.
}
\examples{
t <- runif(120)
knot <- 6
Gu(t,knot)
}
\references{
Wood, S. (2006) Generalized additive models: An R introduction. Chapman and Hall.

Carlos Alberto Cardozo Delgado. Semi-parametric generalized log-gamma regression models. Ph. D. thesis. Sao Paulo University.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>, G. Paula and L. Vanegas.
}
