% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_metrics.R
\name{extract_metrics}
\alias{extract_metrics}
\title{Extract metrics}
\usage{
extract_metrics(
  mraster,
  existing,
  data.frame = FALSE,
  filename = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{mraster}{spatRaster. Metrics Raster.}

\item{existing}{sf 'POINT'.  Existing plot network.}

\item{data.frame}{Logical. Output as data.frame if \code{TRUE}}

\item{filename}{Character. Path to write output samples.}

\item{overwrite}{Logical. Choice to overwrite existing \code{filename} if it exists.}
}
\value{
An sf or data.frame object of samples with metrics attributes.
}
\description{
Extract metric values to existing samples
}
\note{
If \code{data.frame = TRUE} output will be written using \code{\link[utils]{write.table}}
}
\examples{
#--- Load mraster ---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

#' #--- load existing samples ---#
e <- system.file("extdata", "existing.shp", package = "sgsR")
e <- sf::st_read(e)

extract_metrics(mraster =  mr,
                existing = e)

}
\seealso{
Other extract functions: 
\code{\link{extract_strata}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{extract functions}
