
<!-- README.md is generated from README.Rmd. Please edit that file -->

# sgstar

<!-- badges: start -->

[![Travis build
status](https://travis-ci.com/yogasatria30/sgstar.svg?branch=master)](https://travis-ci.com/yogasatria30/sgstar)
<!-- badges: end --> A set of function that implementaion for seasonal
spatio temporal analysis based on Seasonal Generalized Space-Time
Autoregressive with Seemingly Unrelated Regression (S-GSTAR-SUR) Model
by Setiawan et al.(2016)\<Corpus ID: 189955959\>.

## Installation

You can install the released version of sgstar from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("sgstar")
```

## Example

This is a basic example which shows you how to solve a common problem:

``` r
library(sgstar)
#basic example code

data("coords")
data("simulatedata")

#create weight matrix using distance inverse matrix

z<-dist(coords,method = "euclidean")
z <- as.matrix(z)

matriksd <- 1/z
matriksd[is.infinite(matriksd)] <- 0

matriksd_w <- matriksd / rowSums(as.data.frame(matriksd))

fit <- sgstar(data = simulatedata, w = matriksd_w, p = 2,ps = 1, s =4)
fit
#> $Coefficients
#>                GSTARfit$coefficients
#> psi10.i.1.               0.053939128
#> psi10.i.2.              -0.107743691
#> psi10.i.3.               0.045795533
#> psi10.i.4.              -0.045410327
#> psi10.i.5.               0.274600046
#> psi10.i.6.              -0.035212974
#> psi10.i.7.              -0.017168200
#> psi10.i.8.              -0.033392246
#> psi10.i.9.              -0.054459382
#> psi10.i.10.             -0.004400161
#> psi10.i.11.              0.047734055
#> psi10.i.12.              0.065555315
#> psi10.i.13.             -0.002927141
#> psi10.i.14.             -0.007632729
#> psi10.i.15.             -0.074112946
#> psi10.i.16.              0.158924838
#> psi10.i.17.              0.001627666
#> psi20.i.1.              -0.007688152
#> psi20.i.2.               0.010551918
#> psi20.i.3.              -0.147512567
#> psi20.i.4.               0.060988248
#> psi20.i.5.              -0.183393315
#> psi20.i.6.               0.003142465
#> psi20.i.7.              -0.154187588
#> psi20.i.8.              -0.168530153
#> psi20.i.9.              -0.125096128
#> psi20.i.10.              0.094095092
#> psi20.i.11.              0.006319714
#> psi20.i.12.             -0.080790857
#> psi20.i.13.             -0.048078969
#> psi20.i.14.             -0.068786832
#> psi20.i.15.              0.018264848
#> psi20.i.16.              0.067988597
#> psi20.i.17.             -0.015497224
#> psi11.i.1.              -0.072711817
#> psi11.i.2.               0.128455120
#> psi11.i.3.              -0.071605607
#> psi11.i.4.               0.062522612
#> psi11.i.5.              -0.252576723
#> psi11.i.6.               0.050077952
#> psi11.i.7.               0.040917263
#> psi11.i.8.               0.027081230
#> psi11.i.9.               0.068011255
#> psi11.i.10.             -0.008846079
#> psi11.i.11.             -0.081606305
#> psi11.i.12.             -0.071823408
#> psi11.i.13.              0.013539320
#> psi11.i.14.              0.027847446
#> psi11.i.15.              0.050915375
#> psi11.i.16.             -0.155712338
#> psi11.i.17.             -0.025721653
#> psi21.i.1.               0.034746465
#> psi21.i.2.              -0.023828708
#> psi21.i.3.               0.169539926
#> psi21.i.4.              -0.051894206
#> psi21.i.5.               0.167183972
#> psi21.i.6.              -0.015082023
#> psi21.i.7.               0.143330778
#> psi21.i.8.               0.163694850
#> psi21.i.9.               0.111796520
#> psi21.i.10.             -0.067011292
#> psi21.i.11.              0.014302453
#> psi21.i.12.              0.091098770
#> psi21.i.13.              0.052009861
#> psi21.i.14.              0.072390788
#> psi21.i.15.             -0.030260324
#> psi21.i.16.             -0.063607056
#> psi21.i.17.              0.042329471
#> psi10.4..i.1.            0.072122598
#> psi10.4..i.2.            0.122329534
#> psi10.4..i.3.           -0.099928124
#> psi10.4..i.4.            0.041616956
#> psi10.4..i.5.            0.179895980
#> psi10.4..i.6.            0.296960334
#> psi10.4..i.7.            0.030753720
#> psi10.4..i.8.           -0.065075267
#> psi10.4..i.9.           -0.045243753
#> psi10.4..i.10.           0.108275951
#> psi10.4..i.11.          -0.052363439
#> psi10.4..i.12.           0.144162958
#> psi10.4..i.13.          -0.022029035
#> psi10.4..i.14.           0.084636909
#> psi10.4..i.15.           0.064064616
#> psi10.4..i.16.           0.014541155
#> psi10.4..i.17.           0.117184190
#> psi11.4..i.1.            0.917818341
#> psi11.4..i.2.            0.870376001
#> psi11.4..i.3.            1.106078894
#> psi11.4..i.4.            0.930988406
#> psi11.4..i.5.            0.814811992
#> psi11.4..i.6.            0.698157514
#> psi11.4..i.7.            0.956141333
#> psi11.4..i.8.            1.074621363
#> psi11.4..i.9.            1.040874484
#> psi11.4..i.10.           0.877748509
#> psi11.4..i.11.           1.062786646
#> psi11.4..i.12.           0.850645203
#> psi11.4..i.13.           1.012274755
#> psi11.4..i.14.           0.894369079
#> psi11.4..i.15.           0.971540422
#> psi11.4..i.16.           0.981712686
#> psi11.4..i.17.           0.879980194
#> 
#> $Fitted.values
#>          i.1       i.2       i.3       i.4       i.5       i.6       i.7
#> 1   99.46009 100.25870 100.28517  98.97083  99.95998 100.52998 100.30215
#> 2   79.07378  80.20661  80.05421  79.86225  81.13773  79.72602  79.92713
#> 3   79.25581  78.04838  78.90470  79.11465  78.54070  77.88507  78.39939
#> 4   80.46560  80.46373  81.02086  80.18287  78.47912  80.01234  80.14073
#> 5   99.97767  99.94680  99.70453  99.62010 100.78787 100.06663  99.41435
#> 6   79.14428  80.49846  77.94320  79.57433  81.55764  80.80010  80.74145
#> 7   79.89301  78.68686  80.99678  80.10741  79.29846  78.43783  79.25498
#> 8   79.61743  79.70250  79.28110  79.79392  79.08816  79.95547  80.28224
#> 9   99.68539 100.09383 101.22150  99.15331 100.19021 100.56008  99.85665
#> 10  78.48495  78.81145  78.17216  79.52520  80.18674  78.65206  79.47712
#> 11  79.69473  79.22677  80.11530  79.84179  78.60508  78.74830  79.74274
#> 12  80.49911  80.34219  81.47893  80.79563  79.83811  80.49702  80.38743
#> 13  98.72102  99.86131  99.45517  98.77996  99.28296  99.18036  99.39478
#> 14  79.82497  79.67922  80.22502  80.46255  81.22960  78.67638  80.48718
#> 15  80.44159  80.89082  80.89529  80.20291  79.87446  80.96957  80.25410
#> 16  79.94924  80.89427  81.58602  80.16829  79.55045  80.45785  80.06185
#> 17 100.15963  99.73022  99.61786  98.99062 100.19285  99.86298  99.89938
#> 18  78.43460  79.75752  79.77040  79.12954  79.34784  79.34425  79.34349
#> 19  81.04762  80.08618  80.71195  80.77667  80.96432  79.70044  79.89962
#> 20  79.04085  78.79027  79.12477  78.85524  80.24983  78.88654  78.51607
#> 21  99.30907 100.07477 100.65211  99.67633  98.86486  99.89596  98.97323
#> 22  80.08101  80.77451  80.14785  80.40840  80.45744  80.79228  81.25466
#> 23  80.79680  79.46453  81.10585  79.77094  80.57408  79.21978  79.47957
#> 24  78.78284  80.05328  78.84281  79.27279  79.69359  79.58876  79.33696
#> 25  99.13491 100.00375 100.23195  99.12439  99.21953  99.51173  98.59149
#> 26  78.74910  80.95661  78.77105  79.79147  80.43584  80.94067  79.84305
#> 27  81.21870  79.80792  81.43100  80.83312  80.28606  79.61182  80.63816
#> 28  79.29454  79.59454  78.67039  79.76112  79.95641  79.21354  79.62041
#> 29  99.72236  99.16427 100.41095  99.65285 100.39799  99.15288 100.03991
#> 30  79.78575  80.53112  79.72661  80.22879  79.62915  79.96339  80.27516
#> 31  80.02338  79.16942  80.60894  80.08654  80.53858  78.82581  79.34509
#> 32  78.27562  79.09887  79.67453  78.56573  77.94370  78.95214  77.78096
#> 33 100.49995 100.90593 101.16203 100.57988 100.62770 100.20994 100.56811
#> 34  79.47090  80.29378  80.18395  80.12521  79.78578  79.40264  80.83093
#> 35  80.15034  80.02538  79.88964  79.72873  80.47293  80.13328  79.24498
#> 36  79.66516  81.16261  80.65344  79.75328  79.30039  80.81805  80.12272
#> 37  99.74482 100.29276 100.08449  99.29384  99.46865  99.96861  99.42772
#> 38  79.24875  79.97402  79.06499  79.69894  79.24766  79.92992  80.05017
#> 39  80.55390  79.92773  81.83734  80.88259  80.59376  79.92220  80.99001
#> 40  78.97854  79.13940  79.50496  79.26892  78.88075  78.36196  78.42522
#> 41  99.40283 100.20875 100.26463  98.52624  99.54132 100.30089  99.94372
#> 42  80.03042  80.37348  79.83863  80.61895  81.01777  80.01191  80.96888
#> 43  80.17276  80.28067  80.84416  80.85857  79.66795  80.27964  80.76562
#> 44  79.33594  79.71491  79.45297  79.58040  79.61409  79.59589  79.82351
#> 45  99.68007  99.69791 100.43696 100.15012 101.03985 100.02686 100.32451
#> 46  79.57353  80.85896  80.21372  80.98623  80.44800  80.72726  80.12948
#> 47  79.92827  79.69979  79.98717  79.79187  79.94246  79.46154  79.11924
#> 48  80.12471  80.57760  80.84540  80.35479  79.85113  80.16040  79.97886
#> 49  99.38055  98.39121  99.22767  98.47375  99.03028  98.36364  99.99018
#> 50  80.03797  81.55851  81.20707  81.21856  81.48634  81.32614  80.70250
#> 51  79.63801  79.70116  79.69164  79.45407  79.57567  79.56484  79.77058
#> 52  79.44676  79.72236  80.51894  79.62465  79.23384  79.68729  79.19360
#> 53  99.98916  99.89232  99.87669 100.37686 102.23434  98.97570 100.72416
#> 54  78.81505  80.51187  79.52468  79.80458  79.33907  80.68271  80.14151
#> 55  80.38877  80.34430  81.03353  79.92382  79.53604  80.48299  79.76357
#> 56  78.98707  79.09817  79.17547  79.73884  80.36366  79.14377  79.52774
#> 57  99.69307  99.18499 101.20406  99.63697 100.19216  98.83977  99.48852
#> 58  78.78288  79.10765  79.66094  79.14184  80.42709  78.84887  79.63281
#> 59  80.90879  79.43468  81.07734  80.36599  80.61559  79.44540  79.84911
#> 60  79.47671  80.36183  80.46340  79.56735  79.25202  80.07210  79.71155
#> 61 100.01327  99.50652  99.49480  99.83959 100.69414  99.34998 100.59376
#> 62  79.74085  80.77079  79.83579  81.01076  82.24597  80.73134  81.38985
#> 63  80.84615  79.99868  80.62883  80.82855  80.16355  79.80178  80.82716
#> 64  80.37465  80.02641  80.50755  80.74897  80.63054  79.87326  80.56768
#> 65  99.36764 100.34708 100.20789  99.40526  99.93399  99.79800  99.33389
#> 66  80.21536  81.05138  80.50139  81.02125  80.62012  81.06328  81.96638
#> 67  80.15726  78.47675  79.88470  79.80252  78.91211  78.28804  79.48458
#> 68  80.69374  80.65455  80.24043  81.02430  82.38049  80.31321  80.44867
#> 69  99.34063 100.42494 100.51774  99.82654  98.86669  99.97799  99.53108
#> 70  78.62986  79.91178  79.37594  79.70261  78.63502  79.72563  79.96401
#> 71  80.42673  79.12994  79.67564  79.79584  80.14462  78.44788  80.15842
#> 72  80.04602  80.09880  80.63669  80.22863  80.52219  79.88219  80.25220
#> 73  98.79045 100.13714  99.97910  99.57524  99.74381 100.09204  99.66877
#> 74  78.98951  79.76078  79.24526  80.13723  79.52997  78.79608  79.60442
#> 75  80.68767  79.84488  81.71276  80.58500  79.06285  79.61760  80.55512
#> 76  79.97296  78.88398  80.31009  80.05638  80.72269  78.74432  79.91931
#> 77  98.84078  98.68819  98.98847  98.12694  98.50507  98.58264  98.82727
#> 78  79.67685  80.91710  79.03348  80.86371  81.04561  80.09171  80.92421
#> 79  80.41596  79.58826  79.63500  80.02374  79.51341  78.87642  79.66823
#> 80  79.45250  80.02435  80.40973  80.35799  79.02004  79.23956  79.31318
#> 81  98.88869  99.54254  98.85379  98.40865  98.32129  99.81780  99.03444
#> 82  79.59398  79.94996  80.23073  80.18205  80.88449  79.29877  79.93845
#> 83  80.36043  79.33699  80.48846  80.07980  80.60316  79.30409  79.56946
#> 84  79.66692  80.28665  80.58514  79.65837  79.27039  80.59152  80.14454
#> 85  99.64840  99.26295  99.92576  98.77084  99.50814  99.32318  98.75428
#> 86  79.01593  79.87812  79.23683  79.61356  79.58662  79.59869  80.18588
#> 87  79.57404  77.98284  79.58410  79.46739  79.00364  77.76455  78.80103
#> 88  80.94392  81.34008  81.00094  81.01019  81.89958  81.69156  80.96497
#> 89  99.13351  99.50436  99.78874  99.29946 100.13806  99.24644  99.34805
#> 90  80.07906  81.27036  79.69317  80.46919  80.23295  81.16741  80.49213
#> 91  80.42731  79.97350  80.96965  80.16795  79.86170  79.50880  79.64526
#> 92  79.48303  79.45546  79.77986  78.73009  78.82213  79.51856  79.06659
#> 93 100.15671  99.74128 100.41253  99.30293 100.50076  99.58248 100.62005
#> 94  79.95371  81.45799  80.37598  80.86138  81.55941  81.75696  80.99767
#> 95  80.50508  80.49308  81.07063  80.85147  79.90848  80.37642  80.52046
#> 96  79.87091  79.88095  80.91931  80.16513  79.27837  80.35231  80.41921
#>          i.8       i.9      i.10      i.11      i.12      i.13      i.14
#> 1   99.80162  99.82412  99.71683  99.80715  99.47530  99.88816  99.83234
#> 2   79.68616  79.44152  79.41099  77.97164  79.33633  80.57795  80.33160
#> 3   79.02862  78.26334  79.28368  79.51179  78.87062  78.90300  79.21009
#> 4   82.11875  79.45113  80.63260  80.61783  80.47242  80.24408  80.50517
#> 5  100.76092  98.74737 100.06560 100.33463  99.54265 100.21155 100.03840
#> 6   80.07759  79.38101  79.21827  78.30287  78.88737  79.64166  80.89855
#> 7   78.71472  78.58563  80.38034  79.16006  79.95800  80.26683  79.51630
#> 8   79.67899  79.80218  79.60475  79.46509  79.63898  80.09481  79.86075
#> 9  100.24228  99.55155  99.86304 100.40259  99.98125 100.26634  99.80336
#> 10  78.76536  78.60683  78.97276  78.72030  78.36984  78.88363  79.42665
#> 11  79.52545  79.53060  80.27848  79.61652  79.90944  79.82178  79.88793
#> 12  80.43568  79.40224  80.78138  80.34690  80.26067  81.27480  80.62329
#> 13  99.49925  99.27259  99.01901  99.72727  99.32531  99.46309  99.49588
#> 14  78.70093  79.27983  79.54782  78.13457  80.14624  80.98969  80.28773
#> 15  80.84933  79.57967  80.65114  81.81601  79.93188  81.02893  81.48234
#> 16  80.58664  80.32549  80.10059  80.24546  80.29978  80.62648  80.38735
#> 17  99.75678  99.61844  99.69564 100.01932  99.68518  99.70834  99.56407
#> 18  79.75261  79.34761  78.67555  78.17537  78.65101  79.74180  80.02922
#> 19  81.17871  80.18012  81.23826  80.47854  80.79157  80.88939  80.62219
#> 20  79.00462  79.16497  78.86832  78.91141  79.08291  79.18489  79.40099
#> 21 100.17794  99.47241  99.39273  99.62390  99.62056 100.04543 100.16113
#> 22  80.39065  80.79621  80.28961  79.80117  80.17373  81.03300  81.11619
#> 23  79.00120  79.94672  80.33134  80.50000  80.06740  80.16580  79.93802
#> 24  79.56494  78.96118  78.80589  79.45152  79.36327  79.53616  79.76960
#> 25 100.38045  99.47051  99.00287 100.35177  99.45170 100.07745  99.59686
#> 26  79.50323  79.54778  78.98774  79.30471  79.20919  80.72377  80.82323
#> 27  80.01935  79.79291  81.61778  80.24217  80.75327  81.10710  80.52283
#> 28  79.61526  79.35765  79.49283  79.00530  79.91296  80.41732  79.58516
#> 29 100.13905  99.65651 100.25524  99.94330  99.90680 100.03803  99.61661
#> 30  80.13204  79.95720  79.75089  78.90777  79.51849  80.67611  80.61234
#> 31  79.99420  79.38092  80.89439  80.06745  80.54149  80.34613  79.60753
#> 32  78.38723  77.91358  78.43064  78.89471  78.65671  78.75197  79.16110
#> 33 101.10861 100.18814 100.82460 101.22295 100.65215 101.14959 100.57460
#> 34  79.68779  79.22082  79.94903  78.47264  79.52769  80.39821  80.30691
#> 35  79.65332  78.46133  80.35001  80.22968  79.62959  80.89473  80.38879
#> 36  79.83258  79.61113  79.81294  79.55312  79.95604  80.28603  80.44932
#> 37 100.77879  99.43284  99.36593 100.23813  99.36253  99.79642 100.05873
#> 38  78.95578  79.77937  79.06876  79.10775  79.68381  80.19686  80.43084
#> 39  81.02643  79.82543  80.96358  80.81330  80.64369  80.74006  80.34047
#> 40  79.14999  78.73547  79.54279  78.73661  78.80571  79.63953  78.74254
#> 41 100.40942  99.75794  99.48926  99.54051  99.59613  99.87199 100.06762
#> 42  79.86026  79.48569  79.77247  79.39552  80.11633  80.71066  80.91654
#> 43  81.33180  80.28589  81.51595  80.26937  80.25894  80.70496  80.82729
#> 44  79.20025  79.53458  79.83626  79.84086  78.99733  79.52921  79.92521
#> 45 100.34678  99.97660 100.54352 100.49543 100.24039 100.57213  99.85233
#> 46  80.12031  80.34016  80.26177  80.13426  80.49110  80.91208  80.97546
#> 47  79.85035  78.93698  79.98690  79.77257  79.40158  80.19995  80.09730
#> 48  79.94980  79.55894  80.27971  80.22595  79.75387  80.85213  80.61957
#> 49  99.06889  99.73806  99.00194  98.79940  99.39635  99.21641  98.66491
#> 50  81.07432  81.12730  80.44074  80.62035  80.63021  81.00661  81.53031
#> 51  78.87485  79.29518  80.22527  80.56172  79.32946  80.18393  80.12368
#> 52  80.09885  79.63244  79.65427  80.06800  79.59520  79.66489  80.32318
#> 53 100.23265 100.44622  99.79670  99.82471 100.24920 100.87772  99.79306
#> 54  79.65644  79.49453  79.75523  79.71343  79.08886  80.50888  80.49426
#> 55  80.66349  79.42210  81.09783  80.47598  80.38380  80.86170  80.95266
#> 56  78.79973  79.55847  79.06459  79.35687  78.79384  79.52608  79.29928
#> 57 100.36208  99.41161  99.91170  99.72501 100.05755 100.05644  99.61037
#> 58  78.21726  79.47427  79.21660  78.04547  79.38597  79.38283  79.56548
#> 59  79.66339  80.50044  80.78860  79.76408  80.59880  80.75191  80.23958
#> 60  79.87768  79.75821  79.71243  79.84836  79.21126  79.99922  80.15389
#> 61 100.34108 100.27743 100.09544  99.90585 100.15734  99.52750  99.53005
#> 62  80.94701  80.66868  80.25945  80.06622  80.75398  80.83801  81.22970
#> 63  80.77867  79.98929  81.08443  80.83371  80.83803  80.91636  80.53488
#> 64  80.70267  80.04826  80.43449  80.10437  80.55320  80.71052  80.48495
#> 65 100.44584  99.71123  99.35222 100.50047  99.39401 100.57727 100.17836
#> 66  81.45555  80.90728  80.95545  80.11611  80.90061  81.52750  81.40394
#> 67  79.34588  79.73586  79.79153  79.22917  80.13474  79.45554  79.63077
#> 68  81.57162  80.03101  80.86744  79.92842  80.50901  80.33880  80.80807
#> 69 100.70275  99.06469  99.81240 100.26393 100.27412 101.67481  99.98959
#> 70  78.97515  79.54157  79.33608  79.18760  78.92753  80.01694  79.97980
#> 71  79.34666  79.78539  80.17805  79.22254  80.23742  80.50879  79.81248
#> 72  80.53814  80.18094  80.17347  80.35741  80.19499  80.63395  80.36011
#> 73 100.34698 100.04734  99.52228  99.75266  99.32872 100.60036  99.71499
#> 74  80.32110  79.00669  79.74688  78.55655  79.53887  79.74315  79.58043
#> 75  81.29864  80.62585  81.25960  80.49501  80.48294  80.47315  80.85601
#> 76  79.72506  79.16439  80.05935  79.05188  80.09939  79.61908  79.40645
#> 77  98.52645  98.62071  99.02802  98.44814  99.26831  99.27286  98.32771
#> 78  80.50935  80.06624  79.83701  80.03881  80.49209  80.45849  80.90183
#> 79  78.59952  78.87079  79.97401  80.31233  79.83701  80.72080  80.06184
#> 80  79.89652  79.11318  80.01473  80.10522  79.85560  80.99420  80.02087
#> 81  99.53724  99.23008  98.38814  99.20294  98.83321  99.61416  99.47663
#> 82  79.47635  80.08038  79.79442  79.03603  79.95902  80.54497  80.06415
#> 83  78.87152  79.48249  80.55930  79.12257  80.87732  80.62082  79.81061
#> 84  79.78353  79.90849  80.20518  79.32125  79.38918  80.35083  80.36023
#> 85  98.60978  99.34854  99.22741  99.53365  99.85556  99.90936  99.26755
#> 86  77.92729  79.37522  79.43707  78.42793  79.12041  79.94695  79.88065
#> 87  78.69446  78.70620  79.58266  79.34868  79.41347  79.25131  79.05447
#> 88  80.31116  81.00809  80.90172  81.37839  81.06977  81.47155  81.66848
#> 89  99.95463  99.44628  99.54869  99.82852  99.32797 100.27086  99.62973
#> 90  79.91525  80.35068  79.74015  79.89809  80.22562  80.61128  81.45195
#> 91  79.31209  79.92173  80.35433  80.34863  79.94961  80.26963  80.24776
#> 92  79.30692  79.13895  79.10372  79.46561  79.01988  79.49195  79.42480
#> 93  99.54705 100.64887  99.87024 100.07632 100.36829 100.26782  99.88564
#> 94  80.49411  80.98949  80.22999  79.51074  80.24780  81.21091  81.55904
#> 95  80.36511  80.02201  80.87124  81.11552  80.39886  81.12958  81.26165
#> 96  80.88283  79.99042  80.51672  80.09762  80.67610  80.51201  80.58966
#>         i.15      i.16      i.17
#> 1  101.06354 100.61291 100.15068
#> 2   79.12497  79.51023  79.28742
#> 3   78.92201  79.47353  79.36683
#> 4   80.51536  81.22530  80.34221
#> 5  100.73265 100.88471  99.91922
#> 6   79.07683  80.16749  79.18003
#> 7   79.55094  80.39426  79.90042
#> 8   79.86065  80.31569  80.10858
#> 9  100.87286  99.88922  99.69679
#> 10  77.90231  79.23388  78.27731
#> 11  79.59573  80.69344  80.26321
#> 12  80.53253  81.17970  80.23293
#> 13  99.79214  99.13277  99.21267
#> 14  79.74002  79.23848  79.55013
#> 15  80.41109  80.54493  81.17437
#> 16  80.20776  80.58503  80.41117
#> 17 100.80217 100.16609 100.05741
#> 18  78.62505  80.02066  78.65385
#> 19  80.34642  81.43725  81.05210
#> 20  79.35508  79.15715  79.64435
#> 21 100.63424 100.17076  99.98027
#> 22  79.86512  80.66278  79.89918
#> 23  79.87643  80.84377  80.57151
#> 24  79.52745  79.55960  79.55393
#> 25 100.07829 100.55891  99.52191
#> 26  79.24656  79.95205  79.07474
#> 27  80.38107  80.97007  81.38753
#> 28  79.77083  79.90112  79.43971
#> 29 100.85189 100.18116  99.90669
#> 30  79.66408  80.48575  79.76253
#> 31  79.99327  80.48322  80.55900
#> 32  78.80107  78.67732  78.68324
#> 33 101.52998 100.94627 100.67579
#> 34  79.30028  80.49995  79.17224
#> 35  79.72480  80.92774  80.31932
#> 36  79.73635  80.52277  80.10833
#> 37 100.54600  99.95744 100.32467
#> 38  78.84207  79.25040  79.27442
#> 39  80.42465  81.59238  81.02172
#> 40  78.67010  79.89701  78.98649
#> 41 100.85017 100.26833 100.09874
#> 42  79.79349  80.81423  79.69147
#> 43  80.15718  81.17428  80.66222
#> 44  79.64024  79.81034  79.66944
#> 45 101.37943 100.72771 100.27197
#> 46  79.63437  80.56882  79.70311
#> 47  79.33087  79.69386  79.92440
#> 48  80.14161  80.41367  79.95974
#> 49 100.31007  99.41820  99.43628
#> 50  80.27308  81.10722  80.20135
#> 51  79.71989  79.80020  80.21959
#> 52  79.50778  80.30418  79.56713
#> 53 101.13287 100.95002 100.30821
#> 54  78.90470  81.09287  78.76778
#> 55  80.08363  81.35812  80.65515
#> 56  79.15013  79.99033  79.17688
#> 57 100.67623 100.84403  99.96425
#> 58  78.70852  79.28113  78.63157
#> 59  80.08141  80.16037  80.72135
#> 60  79.55761  79.63494  79.69601
#> 61 100.79454 100.97704 100.10023
#> 62  80.60925  82.06105  79.91682
#> 63  80.18793  81.77144  80.95471
#> 64  80.26669  80.60011  80.56176
#> 65 100.71011 100.06111 100.00472
#> 66  80.45338  81.82101  80.36057
#> 67  79.66409  79.74268  80.04724
#> 68  80.55779  81.08553  80.64161
#> 69 100.82896 100.85710  99.85786
#> 70  78.85819  80.42384  78.49709
#> 71  79.72046  80.34019  80.50538
#> 72  80.30205  80.74118  80.34239
#> 73 100.27657 100.02576  99.49735
#> 74  79.22433  79.86313  78.86629
#> 75  80.16211  80.87015  80.92138
#> 76  80.21057  80.44453  79.64426
#> 77 100.14902 100.14147  99.12475
#> 78  79.75017  81.50578  79.82027
#> 79  79.40925  79.82185  80.32136
#> 80  79.89006  80.89688  79.73333
#> 81 100.01222  99.32544  99.43706
#> 82  79.20657  80.06488  79.27170
#> 83  80.14098  79.87067  80.32387
#> 84  80.14147  81.01897  80.13658
#> 85 100.24410 100.33384  99.51927
#> 86  79.04017  80.07356  78.83838
#> 87  78.72653  79.27391  79.47038
#> 88  80.96989  80.85313  81.30948
#> 89 100.73326  99.39657  99.86711
#> 90  79.93149  80.25101  80.02867
#> 91  79.77501  80.02293  80.75347
#> 92  79.43113  79.34773  79.11423
#> 93 101.28362 100.81149 100.05336
#> 94  80.02381  80.94059  80.03537
#> 95  80.81349  81.34581  81.22094
#> 96  80.63561  80.61484  80.14304
#> 
#> $Residual
#>             i.1         i.2         i.3         i.4          i.5         i.6
#> 1  -4.474718340  0.39821582  1.94766128  0.23578241  2.553954167 -0.27694261
#> 2   2.667422435  2.63299080  1.33126612 -4.38547447  0.289032950  3.34613726
#> 3   1.590226609 -0.51160184  3.30865035  0.99154971 -4.944918361  0.20712615
#> 4   3.510337194  1.50088179 -1.63450193 -2.80919873 -0.293541412 -0.19771314
#> 5  -0.874260413  2.17202769 -5.09514221 -0.27441692  1.851463759  3.05038777
#> 6  -1.763990327 -1.73135921  4.10564125 -1.23982932  1.326509692 -3.33853609
#> 7  -1.187397040  2.03515142 -2.57148368  0.42141723  0.472786305 -1.69943622
#> 8  -0.554373841  1.44047301  1.56563587  3.34996961  1.392354026  0.67737771
#> 9  -0.430157712  1.21095188  0.01251871 -0.04759159  0.126750437 -1.58807585
#> 10 -0.218456809 -1.31661746 -0.27255243  2.12784745 -1.874079361 -2.98542365
#> 11  2.886443049  4.75019801  0.30310990 -0.73118071 -1.922039856  2.41636313
#> 12  1.341234685 -3.36648647 -1.50833474  0.41567135 -1.871870563  1.73426256
#> 13  4.128562985 -0.67345071  0.64312243 -0.84248793  2.778202173  2.41274557
#> 14 -1.323698157  0.25221980 -6.16961363  0.92670643  0.230822033 -0.94431045
#> 15 -1.940554235 -3.36770335  2.33361065 -0.98165615  0.652375090 -1.37461176
#> 16 -0.769913024 -2.54647559 -1.49435677 -0.11836210 -1.340529562 -1.75583629
#> 17 -2.114068608  2.06424330  0.19865794  0.37635313 -2.998640781 -0.17217027
#> 18  2.001779201  1.05478695 -0.28681638  2.64103279  1.769213329  1.01931412
#> 19 -1.170797716  1.61268727 -3.12840793  1.33873548  3.784364296 -0.50093919
#> 20 -1.059168069  0.93823406  2.02390860 -3.65089332  0.313748077  1.19609781
#> 21  0.406517656  1.65380498 -0.69591783 -0.20579532 -0.691483662 -2.16522008
#> 22 -0.120172361 -0.44934161 -0.41726859 -0.57799869 -1.603367094  2.54292980
#> 23 -1.907838255 -2.74412965 -0.52799079  4.81256510  1.170096495  0.03998712
#> 24  1.072624203 -1.25803669  5.26293646 -1.25639872  0.577037639 -0.50396292
#> 25 -0.396507361 -2.05137219  1.34617542  3.27664061  3.285612411 -0.89979029
#> 26 -0.651479305 -0.02838524  3.05073646 -1.40386517 -0.008500976 -3.18137568
#> 27 -4.228503668 -1.78184747 -1.47456036 -0.01649215  0.566057077 -1.81415602
#> 28 -4.775844705  1.93724920 -3.38829217 -2.30504320 -0.813158561 -0.09031452
#> 29  1.320442762  1.66711629  1.60531086  1.72854944 -2.294599928 -0.08300731
#> 30 -2.734931685 -0.93292242 -2.72804331  3.71786907  1.556509077 -1.75897690
#> 31 -3.337084032  0.81428972  1.23224276  0.67991720 -1.999753396  2.58085094
#> 32  2.179245031  0.76820947  1.02869390  2.80677961  1.459051450  5.22574057
#> 33 -3.176469225 -3.86560156  0.89466595 -5.02197801 -3.904817462  0.50454334
#> 34  1.772598829  1.03656783 -5.43016451 -1.32740137  2.243068109  0.31968219
#> 35  0.650422584 -4.58923916 -0.30403085  0.79835567 -0.253107908  1.14199796
#> 36  1.342184985 -4.00126640  3.05869060  4.64899358  0.453748739 -2.71460342
#> 37  2.832844008  1.63955690 -2.92358356  1.00910481 -3.406451639  1.76189763
#> 38 -1.582122287  0.66357936 -0.91362913  0.49865983  0.030324590 -1.70550308
#> 39  1.441233267 -1.86626224 -0.32009246 -0.71709004 -2.531656839  2.09083504
#> 40  2.859671762  0.14598946  2.85313434  2.53094127  0.617127624  2.95743825
#> 41  1.474204308  1.07253474  2.10384217  1.86002201  2.188155967 -0.35299914
#> 42 -2.278841932  1.33977846  0.78973899  0.05439768 -0.493718057  0.62701683
#> 43 -0.878033301 -2.32893321  0.38495241 -2.71513170  0.319021862  0.17012485
#> 44 -3.153743727  3.10561047  1.60209903  1.70801558  2.188480187 -0.08038251
#> 45  1.398288631 -1.31506740 -1.40578499 -2.17240065 -0.801597351 -3.41732478
#> 46  0.001680118  0.52985362 -0.30855938  0.82546207  2.292399537  0.48980284
#> 47  2.641884649 -0.53128712  0.76791355 -0.90156815 -0.223393393  1.51696394
#> 48  0.826847765  1.93404716 -2.25342546  0.86781611 -2.036521387 -1.77441617
#> 49  2.339129238  0.83395285  4.15266317 -1.00493815  0.674670241 -1.68076962
#> 50 -3.207056762 -1.31097095 -1.14467438  2.13365831 -1.658452389  0.76788736
#> 51  1.423455372  3.53420839  2.67742465  4.29859890 -0.487223904  1.77362587
#> 52  0.761948331 -2.14675462  0.34403803 -4.05079245  6.240098900  0.84253349
#> 53 -3.229890576 -0.07390802 -2.18549083 -1.84329505 -0.501860855 -2.24659752
#> 54  1.767711296 -1.06546560 -3.14599099  2.78381092  0.815829966 -2.22386782
#> 55  2.464381663 -0.57584890 -4.54736380  0.07377654  2.543868386 -0.79974271
#> 56 -2.037131263  2.13799665 -1.49008251 -0.04709574  0.441231960  1.90094986
#> 57  0.594338124 -0.47928596  0.45362192  0.29388456  2.986505476  0.56830455
#> 58  2.096963648  2.08110916  1.70494932 -1.09226072  2.605219748  1.31007869
#> 59 -0.218293946 -1.91954932  3.87856806  2.57455321 -0.223420992  0.47467895
#> 60 -1.430598829 -1.54382428  1.39008056 -0.56960195  0.863570867 -0.80191700
#> 61 -2.139812281  2.05113114  1.63951688 -1.05873582  2.327005864 -0.23439775
#> 62  2.911990137  1.33365529 -0.06770698 -0.54685297  0.670289097 -0.38218088
#> 63 -1.141376347 -0.70175954 -1.70768560 -4.07725108  1.829622383 -3.12066814
#> 64 -2.746763321 -2.23221231  2.15042001 -0.42394127  0.965032415  0.17296443
#> 65 -3.181420553  1.50734511  1.64714789  2.79293755 -3.211353422 -1.28791677
#> 66  0.082424043  0.55831021  1.78268627 -2.04048150 -5.772579183 -1.44518405
#> 67  2.006562504  0.34089955  0.79663014 -1.85202849  3.595989460 -2.45430888
#> 68 -1.108923941 -0.99611877 -3.18770155 -0.80905212 -2.105523864 -1.66078600
#> 69  3.539273896  0.28459039  2.51956528  0.77507499 -0.726907569  1.13903628
#> 70 -1.434917132 -1.43059083  3.49201851  2.02468168 -0.113880126 -2.81069047
#> 71  1.793834137  1.64326264 -0.55610192  4.30486794  0.758332303 -0.53263594
#> 72 -1.984883804 -1.89166777 -2.67232979  1.61275538  0.849496046 -3.13482053
#> 73  0.312206946 -3.83665346 -0.40395549 -0.04450123 -0.474219516 -0.77796070
#> 74  0.854514450  1.25093292  3.47721694 -0.62047258 -3.769740996 -0.11920740
#> 75 -0.918142246  1.96215899  0.83825708 -4.53663513 -0.274383965 -2.77339118
#> 76 -2.812786925  0.65127238  3.80869404  3.34418532 -4.204005384 -1.28103799
#> 77  1.106698542 -0.53294711  0.19587590 -1.15256957  2.003748048  4.55215054
#> 78 -0.317868791 -4.37442906 -0.05383378 -0.57116319 -0.313651179 -1.38241167
#> 79  2.004559883 -1.34103646  0.60460278  1.05266066  0.223425020  1.93805008
#> 80  0.540515169  0.31880848 -3.44247666  0.90029238 -2.376428481  3.12000528
#> 81  0.242192262 -1.16038368  0.10150421  1.01592124  0.392280867  0.86784170
#> 82 -0.079227301 -0.69432229 -1.35185648 -2.19004161  0.883336823  1.08830786
#> 83 -1.542095015 -0.58532857 -2.08459241 -2.61016972 -0.884039349 -3.37572822
#> 84  2.465850640  2.22295280 -1.15764664 -0.32040255  1.974375610  3.24439970
#> 85  0.417952304 -1.32373073  1.94712319 -0.65460870 -1.953606281 -0.46151094
#> 86  2.750236829  2.87930920  3.44782051 -1.12664776 -0.184757015  2.40713281
#> 87 -0.814525887  2.47278405 -0.47065989 -2.81643058  2.334212330  2.07717554
#> 88 -1.201197889 -0.50943314 -4.86462479 -4.72652273  1.423136794 -1.13488050
#> 89  2.962429822 -0.70345203 -3.01036334  1.08903971  0.813794813  0.69814271
#> 90  1.023012645 -1.70119684  0.72172737 -0.95244988  0.847543733  3.40201028
#> 91  1.603804192  1.13166842  2.65944021  2.08937267 -2.686211276  2.04375908
#> 92  3.140382610  0.89623446 -1.18045875  3.01804758 -0.404094798  1.58647060
#> 93 -1.452848153  0.86420349 -2.26932856 -0.18467493 -1.245720982 -1.21787858
#> 94 -1.675813003 -0.16218216 -1.79443048 -1.66072213 -1.266170473  2.50323498
#> 95 -1.854216610  2.13537076 -1.72940360 -2.83895501 -2.450492461 -2.61966765
#> 96  2.123220496  1.23064052 -0.66269305 -0.25029657 -1.666153069 -0.54812767
#>            i.7         i.8         i.9        i.10         i.11        i.12
#> 1   1.85797850  0.13195109  0.36688516 -0.73742498  2.010077722 -0.25033296
#> 2   0.71000990 -6.10227751  1.43184835 -0.63748716  1.958436486 -1.14861036
#> 3   1.19029600  1.67629997  2.91583522  3.86432980 -0.767276166  2.86571221
#> 4  -5.14738619 -3.28433292  2.79052083  1.69763929 -1.063002982  0.07120062
#> 5   2.30692899 -0.47665113  1.65736147 -1.06610325 -2.636010463 -0.75974928
#> 6  -1.37006312 -1.30598274 -0.50976485 -0.34806681 -4.445357780 -1.51630270
#> 7  -1.22966482 -2.27830652 -0.81572678  2.79264449 -0.711989240 -1.27018105
#> 8  -1.37058324  0.56631758  2.10717518  3.37983576  2.100085699  1.42409074
#> 9  -2.10217814 -1.13656259 -3.77525690 -1.31923760 -0.895991369 -1.20848133
#> 10  2.07090556  2.43200200  3.78762132  0.29088782  2.684337374  1.78085665
#> 11 -1.16515322  3.21254467  0.59179923 -0.78414565  2.400770854 -1.21989304
#> 12 -0.90775561  1.63727573  1.57991808 -3.43312626  1.872213206 -0.97888936
#> 13 -0.72921497  0.96774200  4.45180056  0.86868288 -1.681734257  2.57366212
#> 14 -0.60014684  0.78235973 -1.77735797  0.24595645  5.203826348 -2.70225090
#> 15  1.86127837 -0.32553803  0.63573049  1.01070619 -0.093461500  0.72874100
#> 16 -1.17127488 -2.68973858 -0.53215198 -2.96947299 -3.006692972 -3.29856698
#> 17  1.38420743 -2.56901372 -1.39596887  0.54365022  1.831553467 -1.04583152
#> 18  3.55278071  0.99379604 -0.13770833  0.36939605  1.498644313  0.97097266
#> 19  2.08361161  0.74825007  0.01926389 -2.54406110 -3.202549960  0.11446880
#> 20 -2.21732087 -0.59357699 -0.15554164 -0.24008520 -0.016923858  0.71199747
#> 21  2.55588810  0.96347956 -2.17579474 -3.45249701  1.557054431 -2.44669880
#> 22 -2.40806444  0.21306683 -1.57585441 -1.90149779 -1.102913027 -3.82613333
#> 23  3.11749097  0.68840957  0.68935395 -0.47328004 -0.133069479  1.49077830
#> 24  0.56619704  0.05047289 -1.00288621 -1.68753941  2.071816344  2.03169537
#> 25  0.33621667 -0.20250021  2.58848145  2.03945104 -1.388766957  1.83793660
#> 26  0.81852520  0.34117576  2.29828989 -0.48664444  2.403599011 -0.03293839
#> 27 -1.30285633  0.44106891 -2.13521413 -0.43504376  0.052381344 -0.05737165
#> 28 -0.54540415 -1.87648032 -2.00098025  0.80510383 -2.213226808  0.95555544
#> 29  2.46980511  0.52846525  0.74886315  2.58524114  1.035789491 -1.17790360
#> 30  3.86100961 -0.95503882  0.14298581 -0.04928134  1.158456531  1.44246007
#> 31 -0.18233722  2.94066393  0.77991080 -1.19804315  1.963387926  0.11458798
#> 32 -2.21026293 -0.86861786  3.61363982  1.87140658  1.589824566  2.28845336
#> 33 -0.51553849 -1.40398398  1.42808603 -1.97286700 -0.058126748 -2.59625034
#> 34 -0.76330302  1.34386496  0.62901359 -1.35194150 -0.673793781 -3.98121776
#> 35  0.38610186  1.56067352  0.01331852  0.98677324 -0.286786999 -0.05524115
#> 36 -2.39107617 -1.17421610 -0.96727369  0.84599214 -0.389604460 -7.29864012
#> 37 -3.46879099 -2.35020448  2.06599763 -1.60882191  0.647529609  2.08525755
#> 38  3.54805600  1.45460183  3.24141374  0.58421537 -0.818663822 -0.58858294
#> 39 -1.42481229 -2.75833788 -2.76771178  3.34088323  2.371391445 -0.68571594
#> 40 -2.12184204 -0.41470269  2.31318427 -1.21603997 -3.562248091  0.55886610
#> 41 -2.80054781 -0.71396304 -0.02879502  4.93455577 -0.863283358  1.66258608
#> 42 -1.57306340  1.17442550 -1.81386119  2.77689184 -0.301420183  0.11917556
#> 43 -0.36671019 -0.97538637  0.28439563 -1.03801511  0.980476043 -3.07576115
#> 44  2.98183129  2.99161540 -0.66497038  0.78468723  1.146977824 -1.82092843
#> 45  0.01910845 -1.70336157 -1.39430832 -2.57721224  0.167229693  1.76581430
#> 46 -1.68768878  1.68599986 -0.60049193 -0.38315965 -0.065742119  1.48491092
#> 47 -2.85165056  2.07898520  0.63366103 -0.73409389 -2.491252990  0.80830307
#> 48  3.03251482 -0.57965176 -3.36648110 -0.43078694  0.286017153 -2.42359803
#> 49 -0.65898340  3.55743788 -0.23355800  2.74035560  3.076613587  1.57806539
#> 50  0.07002758  1.71185104 -0.55788165 -2.26469915 -1.662769342 -1.85578221
#> 51 -2.33659419  0.33175388  0.46770990 -2.13969863  0.275555171  0.45617851
#> 52 -2.23168137 -0.10893505 -4.51503650  0.94349032 -4.598878402 -0.43654919
#> 53  0.53097186 -1.50291642 -0.28280031  2.97894344  0.429046424 -1.80827247
#> 54 -1.12458868 -1.62992020  0.56327429 -1.36232060 -5.238586341  0.57309568
#> 55  1.31266032 -0.76152718  1.20832637 -0.14701939 -1.082691849 -2.10681581
#> 56  0.87145163  0.55062584 -1.11876033  2.89886294 -0.607922939 -1.64494791
#> 57  3.16049473 -2.76793974 -1.10752364  0.74175796 -2.644088460  2.38883652
#> 58 -0.25310647  2.07737716 -2.59619012  0.29195822  0.908213914  5.58545263
#> 59 -1.59506080  0.29580351 -0.78689935 -0.69801941  1.192795674  0.45108216
#> 60  0.52816706 -1.18936210  2.12853432  0.76971032  0.501537998 -1.26844239
#> 61 -2.50646655  1.54807008  0.22505457 -2.73860990 -1.174699506 -1.50925488
#> 62 -2.49560294  0.22434236 -0.75826333  0.87539623  1.324579828  1.72672068
#> 63  0.58961423 -4.22134808 -3.88248718 -2.93261907 -0.002017459  1.47913884
#> 64 -1.05845491 -5.53270841  2.47947804  3.42607383  3.166704145  0.05281757
#> 65  0.36224906  3.27633058 -0.91555173 -1.03562605  4.231014883  0.63729748
#> 66 -1.28897405  0.15718970 -3.87223554 -2.04159379 -0.865514357 -1.92479924
#> 67  0.98691737 -0.37093268  1.61728070 -1.98652572  2.975504673 -1.83253197
#> 68 -2.73328993  0.77930362 -0.97930063  2.42117323 -0.585331073 -0.20316761
#> 69 -2.52731095  0.31970897 -1.48295478 -0.46505686  1.091365450 -1.76924501
#> 70  0.80629727 -1.88410451  0.16070912 -0.69336425  0.017070800  1.86964582
#> 71 -0.27124909 -1.35517459 -2.51664949  0.27974820  1.269761423  1.36990751
#> 72  1.19120277 -2.85774371  0.15112990  1.93363590 -1.926596712  0.93239600
#> 73 -0.30865321 -2.90266076 -1.48814665 -0.67574791  0.856818161  3.54528245
#> 74  1.03160584 -0.51785852  0.91908491 -1.64121292  0.353220079  1.62461859
#> 75  1.69650446  2.21422069  1.73709297 -1.09830724 -3.648569176 -1.40634354
#> 76 -1.89282297  2.41733896 -0.04772492 -0.32739915  2.426268195 -1.64516757
#> 77 -1.50982513 -0.39679453  1.28784717 -2.66696678  0.291317231 -0.02037237
#> 78  1.13980110  1.88550118  0.07700829 -2.37619397 -2.111524020  0.15396025
#> 79  0.26444515 -0.85423132 -0.18319745 -1.32875760  1.128756558  2.46962759
#> 80  2.92212800 -2.37198689 -1.57351275  1.18084953  0.492510503 -0.07588180
#> 81  3.86177349  3.17017190  1.71947708  1.11401336 -2.090310424 -0.80055779
#> 82 -2.98625587 -0.06659808  0.14261837  1.82671390 -1.949040100  3.45660569
#> 83  2.14333576  0.13375172 -1.65792472 -2.01946622 -2.371996379 -4.40803918
#> 84  1.80391890  2.88405426  0.63710025  3.72466286 -1.988801481  0.69880117
#> 85 -0.67135978  3.05358912 -0.21584493  0.11780014  1.768055840 -3.20692383
#> 86  0.95030970  1.45038586  2.06893388 -0.62596095 -0.173717225  0.14732830
#> 87  0.11112255  1.32489509  0.36551974  2.66993533 -0.290760223  1.46137122
#> 88  0.03892356  0.95965248 -0.38215068 -3.74387236 -1.909810476 -0.42274923
#> 89  2.63855413  1.72555553 -0.85616035  0.85790087 -1.611570016  3.89290950
#> 90  1.04888878 -0.35228586 -1.45471243  2.83658908  1.298652644  0.40809476
#> 91 -1.45364295  0.99129870 -0.87213347 -0.52796507  0.216797121  1.80035223
#> 92  1.59446371 -0.94167588 -1.31818634  0.01600449  0.167940617  3.85528520
#> 93 -1.77413955  2.48112886 -0.51665755 -3.73038202 -1.516548219  0.33162764
#> 94 -1.17309611 -3.42789558  0.31383222  1.52912309  2.407668359 -1.76170892
#> 95  0.09838715 -2.75630105  2.87908604 -0.09768713  0.919483880  1.96893815
#> 96  4.72768403  3.95987166  0.98635796  3.10582287  0.769362402  0.28107579
#>            i.13        i.14       i.15        i.16        i.17
#> 1   4.233947219 -0.69762670 -2.3228433 -2.17470542  0.07392705
#> 2  -1.605989304 -0.03754197 -1.8127186  0.81669728 -0.37323568
#> 3  -1.871738764 -0.01188408 -0.2007017  0.95925264 -1.88910505
#> 4  -2.064600004 -1.98741467 -1.3689361  0.27606997  0.95645091
#> 5  -0.505696784 -2.91005582 -1.2189932  3.16868220 -1.95521171
#> 6   1.712451545  2.29968303 -1.0348092 -1.02880695 -2.42422540
#> 7  -2.196930700  1.97743133  1.8048693  2.19881581  2.09831183
#> 8   1.039653888  0.45281482 -0.6661339 -0.16472155 -2.51384023
#> 9  -0.058446928 -1.40452147  1.7745443  0.17310672 -1.34402064
#> 10 -3.408935831  2.68276105  0.3030372  5.56383100  4.24909392
#> 11  5.446483057 -0.49859667  0.6012593 -2.07185743  0.36535078
#> 12  2.171993051 -2.23182394  2.3220806 -3.35327845  0.91131200
#> 13  0.923344223 -1.53048400  0.2364226 -2.17298504 -0.55937106
#> 14  0.501910469  0.69244170 -3.7334298 -2.05614777  2.28556466
#> 15  1.150997002 -0.28476646  0.5829921 -1.46106698  0.66056426
#> 16 -0.582442373 -0.18742171 -0.4380033 -1.38810392  4.27807483
#> 17  0.032828030  0.68676474 -1.2242506  1.57666070  3.05995373
#> 18  0.620930353  1.62311528  2.1637774  1.45650904  0.80389288
#> 19 -0.867770108 -2.66918693 -3.5782649 -3.16012128  0.67949180
#> 20  2.464869144  0.34308668 -0.5316184  2.17922670  2.36595046
#> 21  3.175248391  3.51975348  2.1023604 -2.68191056 -2.74896263
#> 22 -1.232658721 -0.85737901  0.9658227  1.96024135 -3.21059868
#> 23 -2.679191397  4.04855187 -0.5779855 -0.04169109  3.69772522
#> 24 -1.636893396 -2.73705770  0.4185964  2.32542825 -0.81191112
#> 25  0.572210651  1.44987933 -3.0690922 -0.67822891  0.82915185
#> 26 -0.785450415 -0.11740818  3.4190736 -0.74665580  2.35174911
#> 27 -0.135476735 -2.21829388  0.8728811 -0.01139498  1.52295764
#> 28 -0.877044236  1.51304110  0.2427133 -3.40286002 -0.33071892
#> 29  2.960106388  5.15270387 -0.8221326  2.11981854 -1.66574431
#> 30 -2.873449763  0.05395509 -2.2101470 -1.48952371  0.10623366
#> 31 -1.500077376  3.01108834 -2.2668452 -2.24454397 -1.53016926
#> 32  0.252016288 -0.39312890  1.2403830  0.49701228  2.14101866
#> 33  2.524340727  1.82712186  0.6063818  0.32385363  1.89798114
#> 34 -0.767513513  0.69638779 -0.4746661  0.61234231  2.39524947
#> 35  4.235453759 -1.71520469  4.8388580  0.07708015  0.07307165
#> 36 -2.345486211 -1.29682190  2.1113595 -1.90100232 -2.35540614
#> 37 -1.183025876  0.52933302  0.7612849 -1.08844867  0.11522637
#> 38 -0.044040525  3.98214690  0.5886617  3.12463989 -0.08991618
#> 39  2.728934437  0.32640231 -2.5056095 -0.62524431 -1.68648190
#> 40 -0.218757568  0.04957174 -2.0726242  0.96853474  3.16075786
#> 41 -0.416492909 -1.50203518 -1.2408206  2.35819849 -0.07337753
#> 42  2.009200536 -3.03317928  0.2821313  0.35037905  1.50014491
#> 43  0.442965507  1.84426196 -1.0801478 -1.55900790 -4.82834887
#> 44  0.688261303  0.88924329 -1.3196071  1.08191995 -0.40026858
#> 45 -1.184280771 -1.85503958  1.2056399 -3.40889818 -0.34684935
#> 46  3.487650487  0.20484925 -0.5400486 -0.31170758  0.84528476
#> 47  1.622769990  2.29826134 -2.7154012 -0.16327545 -0.55036417
#> 48  3.695360038 -0.32781449 -1.0091658 -2.59313318 -1.72912051
#> 49  0.008829378  2.13015189  1.7263524  0.02136607  1.02022276
#> 50  2.109302245 -2.98890555 -3.2809867 -2.24079222 -4.41026046
#> 51 -0.781765492  0.49586429  0.7894740  0.55273849 -2.36895936
#> 52  0.091053582 -1.08158898 -1.1867539  1.05963285  2.07566622
#> 53  0.931316147 -1.09228800  1.6617816  1.37552564  0.56090073
#> 54 -4.129685634 -0.94542253 -0.7080004  0.12636871  1.24404688
#> 55 -4.009599691 -2.28454038  1.0400144  2.40562263 -0.38845888
#> 56  0.720814643 -0.45199050  1.0479627  2.26076330  0.98804846
#> 57 -0.398131215 -0.26439590  0.2421853 -1.69489965  1.15697554
#> 58  4.067836142  1.22202178  0.4977385  2.23752656  1.10189597
#> 59  3.220798054  0.49034840  0.4738431 -0.99264306 -0.34723637
#> 60  1.047798540 -0.77389621  4.9855363  4.39144564  0.81336483
#> 61 -1.401212391  2.12121063 -0.9021699  3.40833969  1.12943499
#> 62 -0.977045608 -1.69947278  2.5279796 -1.28676968 -1.14243407
#> 63  0.997439195 -3.53734881  1.0445043 -1.59785314 -0.36819346
#> 64  2.326657538  1.43839408  0.5477499  1.43556336 -0.64741825
#> 65 -0.490426454 -1.73401890  1.1600295  2.80444082 -2.35420546
#> 66  0.668607310 -4.03727510 -1.7540103 -4.19323867 -3.31969450
#> 67 -1.692564282  1.97475112  2.4996350  1.03799541 -0.96584943
#> 68  1.171252712  1.05048344  1.8237120 -0.60712946  0.67940711
#> 69 -4.583563159 -0.19125458 -2.0205651  1.42583676 -2.05364862
#> 70  1.190206481  0.59599662 -2.1028497  0.86291896  0.74762311
#> 71  2.507247091  1.04325981  0.2935381 -0.16646476  1.22543568
#> 72 -1.269508053  2.06904938  0.9992409  0.42836629 -3.84663338
#> 73 -1.818909754 -3.81331345 -0.9668639 -2.00755827  1.51624439
#> 74  5.002756623  2.38921793  5.0225500 -1.01745635 -0.71674272
#> 75 -3.280117618  2.07459329 -2.6514104  0.43502959 -1.58336910
#> 76  1.136604695  1.30177359 -0.4126478  2.38481313 -0.66157546
#> 77 -1.474560263  1.22873633  1.5169604  0.32166424  0.28950920
#> 78  0.425607141 -0.20259455  2.7552516 -1.55373986 -1.95890795
#> 79 -4.316088500 -2.86484807  0.9158490  2.13962458 -1.70564129
#> 80 -2.609545822  0.20820364 -0.2491005 -0.78718701  2.86494746
#> 81 -2.000762511  0.40239473  3.8878290 -2.12520490 -1.79922669
#> 82 -3.760128753 -0.12747553 -0.9246481 -1.69386244 -0.71948559
#> 83  0.410091689 -0.36620490 -1.7073147  4.25078800  0.35504522
#> 84 -1.179592087  1.20935854 -0.1952284 -0.23050933  2.69811156
#> 85  0.905515013  1.18195141 -0.2211746  1.93933534  3.58272991
#> 86  1.070313702 -0.13402112  2.3209048  0.48199979  0.58564997
#> 87  1.594202167  0.92313820  3.9092957 -1.23942620  2.95613366
#> 88  1.295495457 -4.47971487 -5.8716388 -3.26468939 -3.98018014
#> 89 -1.644442125  2.20163570 -1.0255822 -0.92929434  0.05625612
#> 90 -1.726367759  2.27309518  0.7490754 -1.31936852 -2.18019817
#> 91  0.700649659 -0.92968876 -0.9546141  0.89265853  2.53916028
#> 92  0.738809335  0.12867620 -1.1370202  2.83789165  1.24823460
#> 93  0.611494409 -2.88096871 -1.1916279 -2.13949110 -0.75711127
#> 94 -2.443806108 -3.21649872 -2.8289758 -0.08836747  0.41438915
#> 95 -3.466705661 -2.25718221 -1.5487682 -1.84381086  0.05176940
#> 96 -2.925546447  0.45844558  0.1110532 -0.14224136 -3.13887581
#> 
#> $Performance
#>        MSE     RMSE      AIC   Rsquare
#> 1 3.988201 1.997048 7624.918 0.9491147
#> 
#> $p
#> [1] 2
#> 
#> $ps
#> [1] 1
#> 
#> $s
#> [1] 4
#> 
#> $data
#>           i.1       i.2       i.3       i.4       i.5       i.6       i.7
#> 1    99.53168  96.68978  98.33306 104.61777  99.47289 103.99422  99.51432
#> 2    81.40727  78.07461  77.60493  79.99825  81.40202  79.50532  79.98745
#> 3    79.77997  79.57243  81.51190  79.68955  79.49399  76.69739  76.48095
#> 4    78.62118  80.28480  78.92662  82.83918  81.05148  79.28000  80.85111
#> 5    94.98537 100.65692 102.23283  99.20662 102.51393 100.25304 102.16012
#> 6    81.74120  82.83961  81.38548  75.47677  81.42676  83.07216  80.63714
#> 7    80.84603  77.53677  82.21335  80.10620  73.59578  78.09219  79.58969
#> 8    83.97594  81.96461  79.38636  77.37367  78.18558  79.81463  74.99334
#> 9    99.10341 102.11883  94.60939  99.34568 102.63934 103.11702 101.72127
#> 10   77.38029  78.76710  82.04884  78.33450  82.88415  77.46156  79.37138
#> 11   78.70561  80.72201  78.42530  80.52883  79.77124  76.73839  78.02532
#> 12   79.06306  81.14297  80.84674  83.14389  80.48051  80.63285  78.91166
#> 13   99.25523 101.30478 101.23402  99.10572 100.31696  98.97200  97.75447
#> 14   78.26650  77.49484  77.89960  81.65305  78.31266  75.66664  81.54803
#> 15   82.58117  83.97697  80.41841  79.11061  76.68304  81.16466  78.57758
#> 16   81.84035  76.97571  79.97060  81.21130  77.96624  82.23128  79.47967
#> 17  102.84959  99.18786 100.09829  97.93747 102.06116 101.59310  98.66557
#> 18   78.50127  79.93144  74.05541  81.38926  81.46042  77.73207  79.88704
#> 19   78.50104  77.52312  83.22890  79.22125  80.52684  79.59496  82.11538
#> 20   79.17932  78.34779  80.09167  80.04992  78.20992  78.70202  78.89057
#> 21   98.04557 101.79446  99.81652  99.36698  97.19421  99.69081 101.28358
#> 22   80.43638  80.81231  79.48359  81.77057  81.11706  80.36357  82.89627
#> 23   79.87682  81.69887  77.58354  82.11540  84.74869  79.19951  81.98323
#> 24   77.98169  79.72850  81.14867  75.20434  80.56358  80.08263  76.29875
#> 25   99.71559 101.72857  99.95619  99.47054  98.17337  97.73074 101.52911
#> 26   79.96084  80.32517  79.73058  79.83040  78.85408  83.33521  78.84660
#> 27   78.88896  76.72041  80.57786  84.58351  81.74418  79.25977  82.59706
#> 28   79.85547  78.79524  84.10575  78.01639  80.27063  79.08479  79.90316
#> 29   98.73840  97.95237 101.57812 102.40103 102.50515  98.61194  98.92770
#> 30   78.09762  80.92823  81.82178  78.38761  80.42734  77.75929  80.66158
#> 31   76.99020  78.02607  79.95644  80.81663  80.85212  77.79767  79.33530
#> 32   74.51869  81.53179  75.28209  77.45608  79.14325  79.12322  79.07501
#> 33  101.04281 100.83138 102.01626 101.38140  98.10339  99.06987 102.50971
#> 34   77.05081  79.59820  76.99856  83.94666  81.18566  78.20441  84.13617
#> 35   76.68629  79.98371  81.84119  80.76645  78.53882  81.40666  79.16276
#> 36   80.45487  79.86708  80.70323  81.37251  79.40275  84.17788  75.57070
#> 37   97.32348  97.04033 102.05669  95.55790  96.72288 100.71448 100.05257
#> 38   81.24350  81.33035  74.75378  78.79781  82.02884  79.72232  80.06762
#> 39   80.80076  75.43614  79.58561  80.52709  80.21983  81.27527  79.63108
#> 40   81.00734  77.16134  83.71213  84.40227  79.75414  78.10345  77.73164
#> 41  102.57767 101.93232  97.16090 100.30294  96.06220 101.73050  95.95893
#> 42   77.66663  80.63760  78.15136  80.19760  79.27798  78.22442  83.59822
#> 43   81.99513  78.06146  81.51725  80.16550  78.06210  82.01303  79.56519
#> 44   81.83821  79.28539  82.35809  81.79986  79.49788  81.31940  76.30338
#> 45  100.87703 101.28129 102.36847 100.38626 101.72948  99.94789  97.14318
#> 46   77.75158  81.71326  80.62836  80.67334  80.52405  80.63893  79.39581
#> 47   79.29472  77.95173  81.22911  78.14344  79.98697  80.44976  80.39891
#> 48   76.18220  82.82052  81.05506  81.28842  81.80257  79.51551  82.80534
#> 49  101.07836  98.38285  99.03118  97.97772 100.23825  96.60953 100.34362
#> 50   79.57521  81.38882  79.90516  81.81170  82.74040  81.21706  78.44179
#> 51   82.57016  79.16850  80.75509  78.89030  79.71906  80.97851  76.26759
#> 52   80.95156  82.51165  78.59197  81.22261  77.81461  78.38598  83.01138
#> 53  101.71968  99.22517 103.38034  97.46881  99.70495  96.68288  99.33120
#> 54   76.83092  80.24754  80.06240  83.35222  79.82788  82.09403  80.77253
#> 55   81.06146  83.23537  82.36906  83.75267  79.08845  81.33847  77.43399
#> 56   80.20871  77.57560  80.86298  75.57386  85.47394  80.52982  76.96192
#> 57   96.75927  99.81841  97.69120  98.53357 101.73248  96.72911 101.25514
#> 58   80.58277  79.44640  76.37869  82.58839  80.15490  78.45884  79.01692
#> 59   82.85315  79.76845  76.48617  79.99760  82.07990  79.68325  81.07624
#> 60   76.94994  81.23617  77.68539  79.69175  80.80489  81.04472  80.39919
#> 61  100.28741  98.70570 101.65768  99.93085 103.17866  99.40808 102.64902
#> 62   80.87984  81.18876  81.36589  78.04958  83.03231  80.15895  79.37970
#> 63   80.69050  77.51513  84.95590  82.94054  80.39217  79.92008  78.25405
#> 64   78.04611  78.81801  81.85348  78.99775  80.11559  79.27019  80.23971
#> 65   97.87345 101.55765 101.13432  98.78086 103.02115  99.11558  98.08730
#> 66   82.65284  82.10445  79.76808  80.46391  82.91626  80.34915  78.89424
#> 67   79.70478  79.29692  78.92114  76.75130  81.99318  76.68111  81.41677
#> 68   77.62788  77.79420  82.65797  80.32503  81.59557  80.04622  79.50922
#> 69   96.18622 101.85442 101.85503 102.19820  96.72264  98.51008  99.69613
#> 70   80.29779  81.60969  82.28408  78.98077  74.84755  79.61809  80.67741
#> 71   82.16382  78.81765  80.68133  77.95049  82.50810  75.83373  80.47150
#> 72   79.58481  79.65843  77.05272  80.21524  80.27497  78.65243  77.71538
#> 73  102.87990 100.70953 103.03731 100.60162  98.13978 101.11703  97.00377
#> 74   77.19494  78.48119  82.86796  81.72729  78.52114  76.91494  80.77031
#> 75   82.22056  80.77321  79.11954  84.10071  80.90295  77.91525  79.88717
#> 76   78.06114  78.20713  77.96436  81.84138  81.37169  76.74737  81.44340
#> 77   99.10266  96.30049  99.57514  99.53074  99.26959  99.31408  99.36012
#> 78   79.84402  81.01171  82.72247  79.51676  75.76023  78.67687  80.63602
#> 79   79.76953  81.80704  82.55102  76.04836  78.78847  76.84421  82.25163
#> 80   77.16017  79.53525  84.11878  83.40057  76.51869  77.46328  78.02649
#> 81   99.94748  98.15524  99.18435  96.97437 100.50882 103.13479  97.31744
#> 82   79.35899  76.54267  78.97964  80.29254  80.73196  78.70930  82.06401
#> 83   82.42052  78.24722  80.23960  81.07640  79.73684  80.81447  79.93267
#> 84   79.99301  80.34316  76.96725  81.25828  76.64361  82.35956  82.23531
#> 85   99.13088  98.38215  98.95530  99.42457  98.71357 100.68564 102.89621
#> 86   79.51475  79.25564  78.87887  77.99201  81.76783  80.38708  76.95219
#> 87   78.81833  78.75166  78.40387  77.46963  79.71912  75.92836  81.71279
#> 88   82.13277  82.50961  79.42749  79.33797  81.24477  83.83592  81.94845
#> 89  100.06635  97.93922 101.87289  98.11623  97.55453  98.86167  98.08292
#> 90   81.76617  82.75743  82.68465  78.48692  79.40187  82.00583  81.13619
#> 91   78.75952  80.45563  79.11344  76.65096  81.33785  79.84173  78.91215
#> 92   79.74272  80.83064  76.13631  76.28367  83.32272  80.55668  81.00389
#> 93  102.09594  98.80090  96.77837 100.38850 100.95186  99.94458 101.98660
#> 94   81.10208  79.56916  80.41489  79.51674  81.08049  84.56942  81.54102
#> 95   82.03111  81.10517  83.62909  82.25732  77.17549  81.55256  78.19161
#> 96   82.62341  80.35169  78.59940  81.74814  78.41804  81.10503  80.66106
#> 97   98.70386 100.60548  98.14320  99.11826  99.25504  98.36460  98.84592
#> 98   78.27790  81.29581  78.58155  79.20066  80.29324  84.26020  79.82457
#> 99   78.65086  82.62845  79.34122  78.01251  77.45799  77.75675  80.61884
#> 100  81.99413  81.11159  80.25662  79.91484  77.61222  79.80418  85.14690
#>           i.8       i.9      i.10      i.11      i.12      i.13      i.14
#> 1    98.89052  98.94105 101.40947  98.12223 101.75053  98.51127 103.45815
#> 2    80.28933  81.06489  77.64793  84.96731  77.33666  77.27846  79.52982
#> 3    79.21443  78.12697  76.46952  76.48138  81.44496  80.21181  80.78027
#> 4    79.17742  82.14185  82.09364  79.27885  79.50776  85.26569  80.16575
#> 5    99.93357 100.19100  98.97941 101.81723  99.22497 104.12211  99.13471
#> 6    73.58389  80.87336  78.77350  79.93008  78.18772  78.97196  80.29406
#> 7    80.70492  81.17918  83.14801  78.74451  81.73633  77.03126  79.19820
#> 8    78.83441  82.24165  82.33023  79.55483  80.54362  78.17948  78.51776
#> 9   100.28427 100.40473  98.99950  97.69862  98.78290  99.70585  97.12834
#> 10   78.77160  78.87125  78.87021  73.85751  77.37107  81.35411  83.19823
#> 11   76.43641  77.76990  83.17298  78.44807  78.68782  78.06990  81.49373
#> 12   80.24530  81.90935  82.98458  81.56517  81.06307  81.13447  80.31356
#> 13   99.10572  95.77629  98.54380  99.50660  98.77277 100.20790  98.39884
#> 14   81.19736  82.39445  79.26365  81.40464  80.15069  75.47470  82.10941
#> 15   82.73800  80.12240  79.49433  82.01729  78.68954  85.26826  79.38933
#> 16   82.07295  80.98216  77.34826  82.21911  79.28178  83.44679  78.39147
#> 17  100.46700 103.72439  99.88769  98.04554 101.89897 100.38643  97.96540
#> 18   79.48329  77.50247  79.79378  83.33839  77.44399  81.49160  80.98017
#> 19   80.52379  80.21540  81.66184  81.72255  80.66062  82.17992  81.19758
#> 20   77.89691  79.79334  77.13111  77.23876  77.00121  80.04404  80.19993
#> 21   97.18776  98.22247 100.23929 101.85087  98.63935  99.74117 100.25083
#> 22   80.74641  79.20990  79.04494  79.67401  79.62198  80.36273  81.65234
#> 23   81.92696  80.19939  78.69420  77.27599  80.90604  80.02162  77.95301
#> 24   78.41105  79.00943  78.62824  78.89449  79.79491  81.64976  79.74408
#> 25  101.14142  97.29661  95.94023 101.18096  97.17386 103.22068 103.68089
#> 26   80.60371  79.22036  78.38811  78.69825  76.34759  79.80034  80.25881
#> 27   79.68961  80.63607  79.85806  80.36693  81.55818  77.48661  83.98657
#> 28   79.61541  77.95829  77.11835  81.52334  81.39497  77.89927  77.03255
#> 29  100.17795 102.05899 101.04232  98.96300 101.28964 100.64966 101.04674
#> 30   79.84441  81.84607  78.50109  81.70831  79.17626  79.93832  80.70582
#> 31   80.46042  77.65769  81.18274  80.29455  80.69590  80.97163  78.30454
#> 32   77.73878  77.35667  80.29793  76.79208  80.86851  79.54027  81.09820
#> 33  100.66752 100.40538 102.84048 100.97909  98.72890 102.99813 104.76931
#> 34   79.17700  80.10019  79.70161  80.06623  80.96095  77.80266  80.66629
#> 35   82.93486  80.16083  79.69635  82.03084  80.65608  78.84605  82.61862
#> 36   77.51861  81.52722  80.30204  80.48454  80.94516  79.00398  78.76797
#> 37   99.70463 101.61622  98.85173 101.16482  98.05590 103.67393 102.40173
#> 38   81.03166  79.84983  78.59709  77.79885  75.54647  79.63070  81.00330
#> 39   81.21399  78.47465  81.33679  79.94289  79.57435  85.13018  78.67358
#> 40   78.65836  78.64386  80.65894  79.16351  72.65740  77.94054  79.15250
#> 41   98.42859 101.49884  97.75711 100.88566 101.44778  98.61339 100.58807
#> 42   80.41038  83.02078  79.65297  78.28909  79.09523  80.15282  84.41299
#> 43   78.26809  77.05772  84.30446  83.18469  79.95797  83.46899  80.66687
#> 44   78.73529  81.04865  78.32675  75.17436  79.36457  79.42078  78.79211
#> 45   99.69545  99.72914 104.42382  98.67723 101.25871  99.45550  98.56558
#> 46   81.03468  77.67183  82.54936  79.09410  80.23551  82.71986  77.88336
#> 47   80.35642  80.57029  80.47793  81.24985  77.18317  81.14792  82.67155
#> 48   82.19186  78.86961  80.62095  80.98784  77.17641  80.21747  80.81446
#> 49   98.64341  98.58229  97.96631 100.66266 102.00620  99.38785  97.99729
#> 50   81.80631  79.73967  79.87861  80.06851  81.97601  84.39973  81.18031
#> 51   81.92933  79.57064  79.25281  77.28132  80.20988  81.82272  82.39556
#> 52   79.37015  76.19246  79.84892  80.51196  77.33028  84.54749  80.29175
#> 53  102.62632  99.50450 101.74229 101.87601 100.97441  99.22524 100.79507
#> 54   82.78617  80.56942  78.17605  78.95758  78.77443  83.11591  78.54141
#> 55   79.20660  79.76289  78.08557  80.83728  79.78564  79.40216  80.61954
#> 56   79.98992  75.11740  80.59776  75.46912  79.15865  79.75595  79.24159
#> 57   98.72973 100.16342 102.77564 100.25376  98.44092 101.80904  98.70077
#> 58   78.02652  80.05780  78.39290  74.47485  79.66196  76.37920  79.54883
#> 59   79.90196  80.63043  80.95081  79.39329  78.27699  76.85210  78.66812
#> 60   79.35036  78.43971  81.96345  78.74895  77.14889  80.24690  78.84729
#> 61   97.59414  98.30409 100.65346  97.08093 102.44639  99.65831  99.34597
#> 62   80.29464  76.87808  79.50856  78.95369  84.97142  83.45067  80.78750
#> 63   79.95919  79.71354  80.09058  80.95687  81.04989  83.97270  80.72993
#> 64   78.68832  81.88674  80.48214  80.34989  77.94282  81.04702  79.37999
#> 65  101.88915 100.50249  97.35683  98.73115  98.64809  98.12629 101.65126
#> 66   81.17136  79.91042  81.13484  81.39080  82.48070  79.86096  79.53022
#> 67   76.55732  76.10681  78.15181  80.83169  82.31717  81.91380  76.99754
#> 68   75.16996  82.52774  83.86056  83.27107  80.60602  83.03717  81.92335
#> 69  103.72217  98.79568  98.31659 104.73149 100.03131 100.08684  98.44434
#> 70   81.61274  77.03505  78.91386  79.25059  78.97581  82.19611  77.36666
#> 71   78.97495  81.35314  77.80500  82.20468  78.30221  77.76298  81.60552
#> 72   82.35092  79.05171  83.28862  79.34309  80.30584  81.51005  81.85855
#> 73  101.02246  97.58174  99.34734 101.35530  98.50487  97.09125  99.79834
#> 74   77.09104  79.70227  78.64271  79.20467  80.79718  81.20714  80.57580
#> 75   77.99149  77.26874  80.45780  80.49230  81.60733  83.01604  80.85574
#> 76   77.68039  80.33207  82.10711  78.43081  81.12738  79.36444  82.42916
#> 77   97.44432  98.55919  98.84653 100.60948 102.87400  98.78145  95.90167
#> 78   79.80324  79.92578  78.10567  78.90977  81.16348  84.74591  81.96965
#> 79   83.51286  82.36294  80.16129  76.84644  79.07660  77.19303  82.93060
#> 80   82.14240  79.11667  79.73195  81.47815  78.45422  80.75568  80.70823
#> 81   98.12966  99.90855  96.36105  98.73946  99.24794  97.79830  99.55645
#> 82   82.39485  80.14325  77.46082  77.92729  80.64605  80.88410  80.69924
#> 83   77.74529  78.68759  78.64525  81.44109  82.30663  76.40472  77.19699
#> 84   77.52453  77.53967  81.19558  80.59773  79.77972  78.38465  80.22908
#> 85  102.70741 100.94956  99.50215  97.11263  98.03265  97.61340  99.87902
#> 86   79.40975  80.22300  81.62113  77.08699  83.41563  76.78484  79.93667
#> 87   79.00528  77.82456  78.53983  76.75057  76.46928  81.03091  79.44440
#> 88   82.66758  80.54559  83.92984  77.33245  80.08798  79.17124  81.56959
#> 89  101.66336  99.13270  99.34521 101.30170  96.64864 100.81488 100.44950
#> 90   79.37768  81.44415  78.81111  78.25421  79.26773  81.01727  79.74663
#> 91   80.01935  79.07172  82.25260  79.05792  80.87484  80.84551  79.97761
#> 92   81.27082  80.62593  77.15785  79.46858  80.64702  82.76705  77.18876
#> 93  101.68018  98.59012 100.40660  98.21695 103.22088  98.62642 101.83137
#> 94   79.56296  78.89597  82.57674  81.19675  80.63372  78.88491  83.72504
#> 95   80.30339  79.04960  79.82637  80.56543  81.74996  80.97027  79.31808
#> 96   78.36524  77.82076  79.11973  79.63355  82.87517  80.23076  79.55347
#> 97  102.02818 100.13221  96.13986  98.55978 100.69992 100.87931  97.00467
#> 98   77.06621  81.30332  81.75911  81.91841  78.48609  78.76711  78.34254
#> 99   77.60881  82.90109  80.77355  82.03500  82.36780  77.66287  79.00446
#> 100  84.84270  80.97678  83.62254  80.86698  80.95717  77.58647  81.04810
#>          i.15      i.16      i.17
#> 1    98.37002  96.61953 102.98189
#> 2    79.82089  80.40166  79.46927
#> 3    76.71207  78.69037  79.82171
#> 4    78.01251  80.68722  80.09985
#> 5    98.74069  98.43821 100.22461
#> 6    77.31225  80.32692  78.91418
#> 7    78.72130  80.43278  77.47772
#> 8    79.14643  81.50137  81.29866
#> 9    99.51366 104.05339  97.96401
#> 10   78.04202  79.13869  76.75580
#> 11   81.35581  82.59307  81.99873
#> 12   79.19452  80.15097  77.59474
#> 13  102.64741 100.06233  98.35277
#> 14   78.20535  84.79771  82.52640
#> 15   80.19699  78.62158  80.62856
#> 16   82.85461  77.82642  81.14424
#> 17  100.02856  96.95979  98.65330
#> 18   76.00659  77.18233  81.83569
#> 19   80.99409  79.08386  81.83493
#> 20   79.76976  79.19692  84.68925
#> 21   99.57792 101.74275 103.11736
#> 22   80.78883  81.47717  79.45774
#> 23   76.76816  78.27713  81.73159
#> 24   78.82346  81.33638  82.01030
#> 25  102.73660  97.48885  97.23131
#> 26   80.83094  82.62303  76.68858
#> 27   79.29845  80.80208  84.26924
#> 28   79.94605  81.88503  78.74202
#> 29   97.00920  99.88069 100.35106
#> 30   82.66563  79.20540  81.42649
#> 31   81.25395  80.95868  82.91049
#> 32   80.01354  76.49826  79.10899
#> 33  100.02976 102.30098  98.24094
#> 34   77.45393  78.99623  79.86877
#> 35   77.72642  78.23867  79.02883
#> 36   80.04146  79.17434  80.82426
#> 37  102.13636 101.27012 102.57377
#> 38   78.82561  81.11229  81.56749
#> 39   84.56366  81.00482  80.39239
#> 40   81.84771  78.62177  77.75292
#> 41  101.30728  98.86899 100.43990
#> 42   79.43073  82.37504  79.18450
#> 43   77.91904  80.96714  79.33523
#> 44   76.59748  80.86554  82.14725
#> 45   99.60935 102.62653 100.02536
#> 46   80.07562  81.16461  81.19162
#> 47   79.07703  79.61527  75.83387
#> 48   78.32063  80.89226  79.26917
#> 49  102.58507  97.31881  99.92512
#> 50   79.09432  80.25711  80.54839
#> 51   76.61547  79.53058  79.37404
#> 52   79.13244  77.82054  78.23062
#> 53  102.03642  99.43956 100.45650
#> 54   76.99210  78.86643  75.79109
#> 55   80.50936  80.35294  77.85064
#> 56   78.32103  81.36381  81.64280
#> 57  102.79465 102.32554 100.86911
#> 58   78.19670  81.21924  80.01182
#> 59   81.12364  83.76374  80.26669
#> 60   80.19809  82.25109  80.16493
#> 61  100.91841  99.14913 101.12122
#> 62   79.20626  81.51866  79.73347
#> 63   80.55525  79.16772  80.37412
#> 64   84.54315  84.02639  80.50937
#> 65   99.89237 104.38538 101.22966
#> 66   83.13723  80.77428  78.77439
#> 67   81.23243  80.17359  80.58651
#> 68   80.81444  82.03567  79.91435
#> 69  101.87014 102.86555  97.65051
#> 70   78.69937  77.62777  77.04087
#> 71   82.16372  80.78068  79.08139
#> 72   82.38150  80.47840  81.32102
#> 73   98.80840 102.28293  97.80421
#> 74   76.75534  81.28676  79.24471
#> 75   80.01400  80.17373  81.73081
#> 76   81.30129  81.16954  76.49576
#> 77   99.30970  98.01821 101.01360
#> 78   84.24688  78.84567  78.14955
#> 79   77.51070  81.30518  79.33801
#> 80   79.79792  82.82935  78.98269
#> 81  101.66598 100.46313  99.41426
#> 82   82.50542  79.95204  77.86136
#> 83   80.32509  81.96147  78.61572
#> 84   79.64096  80.10969  82.59828
#> 85  103.90005  97.20024  97.63784
#> 86   78.28192  78.37102  78.55222
#> 87   78.43367  84.12146  80.67891
#> 88   79.94624  80.78846  82.83469
#> 89  100.02292 102.27317 103.10200
#> 90   81.36108  80.55556  79.42403
#> 91   82.63583  78.03448  82.42652
#> 92   75.09825  77.58844  77.32930
#> 93   99.70768  98.46728  99.92337
#> 94   80.68057  78.93165  77.84847
#> 95   78.82039  80.91559  83.29263
#> 96   78.29411  82.18562  80.36246
#> 97  100.09199  98.67199  99.29624
#> 98   77.19483  80.85222  80.44976
#> 99   79.26472  79.50200  81.27271
#> 100  80.74666  80.47260  77.00417
#> 
#> $weight
#>                             PALEMBANG LUBUKLINGGAU OGAN KOMERING ULU SELATAN
#> PALEMBANG                  0.00000000   0.03380018                0.03494376
#> LUBUKLINGGAU               0.03101550   0.00000000                0.03471468
#> OGAN KOMERING ULU SELATAN  0.04125860   0.04466818                0.00000000
#> OGAN KOMERING ULU          0.04241035   0.03721798                0.10382571
#> OGAN KOMERING ILIR         0.12037697   0.03655655                0.04773774
#> MUSI RAWAS                 0.03450572   0.20608117                0.03438028
#> OGAN ILIR                  0.12072500   0.03208123                0.04046803
#> PAGAR ALAM                 0.03120858   0.06279090                0.07185250
#> BANYU ASIN                 0.17015675   0.04001052                0.03529062
#> OGAN KOMERING ULU TIMUR    0.05880850   0.03489622                0.07755634
#> EMPAT LAWANG               0.03092347   0.12135025                0.04740220
#> PRABUMULIH                 0.06981156   0.03562429                0.04067243
#> LAHAT                      0.03180947   0.06736744                0.05479144
#> MUSI RAWAS UTARA           0.04056120   0.15183781                0.03732632
#> PENUKAL ABAB LEMATANG ILIR 0.06663032   0.04733006                0.03777301
#> MUARA ENIM                 0.04263182   0.04433232                0.05920133
#> MUSI BANYUASIN             0.07457500   0.06346109                0.03677022
#>                            OGAN KOMERING ULU OGAN KOMERING ILIR MUSI RAWAS
#> PALEMBANG                         0.04909661         0.08318929 0.03931412
#> LUBUKLINGGAU                      0.03953595         0.02318190 0.21545446
#> OGAN KOMERING ULU SELATAN         0.14191539         0.03895209 0.04625000
#> OGAN KOMERING ULU                 0.00000000         0.03685076 0.04097202
#> OGAN KOMERING ILIR                0.06173082         0.00000000 0.04052199
#> MUSI RAWAS                        0.04163031         0.02457862 0.00000000
#> OGAN ILIR                         0.06503225         0.06968873 0.03723441
#> PAGAR ALAM                        0.06951355         0.02573482 0.06123018
#> BANYU ASIN                        0.04634500         0.07083308 0.04643620
#> OGAN KOMERING ULU TIMUR           0.13867215         0.06000182 0.03850551
#> EMPAT LAWANG                      0.05048203         0.02436845 0.09816392
#> PRABUMULIH                        0.07269218         0.04147289 0.04288473
#> LAHAT                             0.06672919         0.02467968 0.07215203
#> MUSI RAWAS UTARA                  0.04257678         0.02993212 0.14140541
#> PENUKAL ABAB LEMATANG ILIR        0.05835609         0.03701431 0.06136838
#> MUARA ENIM                        0.12266036         0.03167335 0.05192420
#> MUSI BANYUASIN                    0.04721888         0.04323004 0.07956856
#>                             OGAN ILIR PAGAR ALAM BANYU ASIN
#> PALEMBANG                  0.13852541 0.03411971 0.13823342
#> LUBUKLINGGAU               0.03377871 0.06299236 0.02982619
#> OGAN KOMERING ULU SELATAN  0.05482634 0.09275090 0.03385073
#> OGAN KOMERING ULU          0.06445867 0.06564794 0.03252274
#> OGAN KOMERING ILIR         0.11570997 0.04071257 0.08326759
#> MUSI RAWAS                 0.03749897 0.05875427 0.03311030
#> OGAN ILIR                  0.00000000 0.03667654 0.06162368
#> PAGAR ALAM                 0.03849366 0.00000000 0.02720106
#> BANYU ASIN                 0.08703942 0.03660608 0.00000000
#> OGAN KOMERING ULU TIMUR    0.09904061 0.04991135 0.04187421
#> EMPAT LAWANG               0.03581256 0.12877691 0.02827255
#> PRABUMULIH                 0.12967830 0.04129860 0.04680410
#> LAHAT                      0.03960609 0.16499982 0.02754822
#> MUSI RAWAS UTARA           0.04127944 0.05592727 0.04160597
#> PENUKAL ABAB LEMATANG ILIR 0.08100058 0.04529773 0.05331829
#> MUARA ENIM                 0.06203289 0.06936188 0.03345738
#> MUSI BANYUASIN             0.06373743 0.04508548 0.09034791
#>                            OGAN KOMERING ULU TIMUR EMPAT LAWANG PRABUMULIH
#> PALEMBANG                               0.05734281   0.03266788 0.09157042
#> LUBUKLINGGAU                            0.03122317   0.11763408 0.04287794
#> OGAN KOMERING ULU SELATAN               0.08928964   0.05912568 0.06299020
#> OGAN KOMERING ULU                       0.11680150   0.04606699 0.08236371
#> OGAN KOMERING ILIR                      0.08466020   0.03725088 0.07871693
#> MUSI RAWAS                              0.03295371   0.09101799 0.04937114
#> OGAN ILIR                               0.08416275   0.03297128 0.14823917
#> PAGAR ALAM                              0.04451504   0.12443409 0.04954866
#> BANYU ASIN                              0.05025990   0.03676494 0.07556974
#> OGAN KOMERING ULU TIMUR                 0.00000000   0.03973201 0.09189158
#> EMPAT LAWANG                            0.03667302   0.00000000 0.04594310
#> PRABUMULIH                              0.06831037   0.03700199 0.00000000
#> LAHAT                                   0.04218798   0.11697983 0.05495658
#> MUSI RAWAS UTARA                        0.03617719   0.07910117 0.04960193
#> PENUKAL ABAB LEMATANG ILIR              0.05047749   0.04492735 0.15446161
#> MUARA ENIM                              0.06580763   0.05345022 0.10604225
#> MUSI BANYUASIN                          0.04425085   0.05043473 0.07353665
#>                                 LAHAT MUSI RAWAS UTARA
#> PALEMBANG                  0.03974064       0.03159348
#> LUBUKLINGGAU               0.07723040       0.10852417
#> OGAN KOMERING ULU SELATAN  0.08082321       0.03432787
#> OGAN KOMERING ULU          0.07201362       0.02864705
#> OGAN KOMERING ILIR         0.04461634       0.03373651
#> MUSI RAWAS                 0.07911696       0.09667082
#> OGAN ILIR                  0.04312292       0.02802130
#> PAGAR ALAM                 0.18855176       0.03984548
#> BANYU ASIN                 0.04236509       0.03989134
#> OGAN KOMERING ULU TIMUR    0.05405406       0.02889899
#> EMPAT LAWANG               0.13834285       0.05832261
#> PRABUMULIH                 0.05234440       0.02945489
#> LAHAT                      0.00000000       0.04042085
#> MUSI RAWAS UTARA           0.06483315       0.00000000
#> PENUKAL ABAB LEMATANG ILIR 0.06071794       0.03942964
#> MUARA ENIM                 0.09864746       0.03242955
#> MUSI BANYUASIN             0.05472255       0.07027592
#>                            PENUKAL ABAB LEMATANG ILIR MUARA ENIM MUSI BANYUASIN
#> PALEMBANG                                  0.08077313 0.05475848     0.06033065
#> LUBUKLINGGAU                               0.05264922 0.05225138     0.04710989
#> OGAN KOMERING ULU SELATAN                  0.05406567 0.08978296     0.03512254
#> OGAN KOMERING ULU                          0.06110849 0.13609498     0.03299748
#> OGAN KOMERING ILIR                         0.06492930 0.05886912     0.05060652
#> MUSI RAWAS                                 0.06529536 0.05853693     0.05649746
#> OGAN ILIR                                  0.08557580 0.06943961     0.04493732
#> PAGAR ALAM                                 0.05022734 0.08149051     0.03336186
#> BANYU ASIN                                 0.07956231 0.05289876     0.08997027
#> OGAN KOMERING ULU TIMUR                    0.06275582 0.08668718     0.03671365
#> EMPAT LAWANG                               0.05155529 0.06498817     0.03862263
#> PRABUMULIH                                 0.14275381 0.10384092     0.04535454
#> LAHAT                                      0.05891606 0.10142032     0.03543502
#> MUSI RAWAS UTARA                           0.06136647 0.05347757     0.07299021
#> PENUKAL ABAB LEMATANG ILIR                 0.00000000 0.09356773     0.06832947
#> MUARA ENIM                                 0.08830873 0.00000000     0.03803862
#> MUSI BANYUASIN                             0.10239019 0.06039451     0.00000000
```

``` r
#example for predict 
predict.fit <-predict_sgstar(fit,12)
predict.fit
#>         i.1      i.2      i.3      i.4      i.5      i.6      i.7      i.8
#> 1  99.01281 99.04052 99.70282 98.40884 98.55172 98.93703 98.81934 99.32169
#> 2  79.37287 81.01615 79.78676 80.02947 80.83710 81.24422 79.36379 79.21101
#> 3  80.50067 79.40486 80.10130 79.81809 79.73917 79.14670 79.75405 79.66205
#> 4  80.97435 80.69920 81.33312 80.98542 80.51655 80.38215 80.89100 79.88582
#> 5  98.65564 99.08158 99.30203 98.60030 98.87603 98.91614 98.87435 99.41675
#> 6  79.27680 80.58863 79.54561 80.11227 80.40080 80.50917 80.22236 79.97997
#> 7  80.18669 79.42627 80.41424 79.98467 79.80485 79.24108 79.75342 79.63550
#> 8  80.72342 80.81896 81.09778 80.84982 80.72270 80.57916 80.82294 81.01549
#> 9  98.66894 98.96706 99.25527 98.51762 98.95275 98.83297 98.83195 99.21389
#> 10 79.39998 80.49892 79.71383 80.16720 80.40728 80.29886 80.24833 79.68735
#> 11 80.26567 79.52538 80.48121 80.08392 79.83144 79.32749 79.79377 79.81524
#> 12 80.70490 80.88124 81.11914 80.82855 80.71572 80.65791 80.78164 80.82975
#>         i.9     i.10     i.11     i.12     i.13     i.14      i.15     i.16
#> 1  98.28362 98.83738 99.69052 98.90326 99.71522 99.16009 100.05300 99.58196
#> 2  79.43142 79.80404 78.77692 79.33319 80.64816 80.89390  79.27820 79.95210
#> 3  79.02080 80.22623 79.35275 80.11908 80.24059 80.23287  79.93231 80.11693
#> 4  80.64482 81.08056 80.57541 81.11117 81.84521 80.80581  80.92984 81.21545
#> 5  98.91366 98.80732 99.10230 98.95306 99.38041 98.96846  99.81214 99.44072
#> 6  79.78602 79.61871 79.35527 79.50648 80.27795 80.73748  79.34018 80.30511
#> 7  79.50688 80.41277 80.00815 80.02726 80.22189 80.09106  79.78361 80.37991
#> 8  80.58810 80.87123 80.66032 80.86860 81.02881 80.94282  80.97177 81.31406
#> 9  98.70680 98.77961 99.07381 98.89453 99.31508 98.90380  99.74607 99.40985
#> 10 79.80231 79.66991 79.28730 79.64498 80.50308 80.66413  79.41794 80.36164
#> 11 79.49171 80.50175 80.00552 80.07498 80.34578 80.16015  79.83662 80.44996
#> 12 80.57968 80.83294 80.69951 80.82063 81.23087 81.00020  80.94723 81.27252
#>        i.17
#> 1  99.15657
#> 2  79.52884
#> 3  80.53337
#> 4  80.58490
#> 5  99.03298
#> 6  79.43498
#> 7  80.40230
#> 8  80.82799
#> 9  98.98471
#> 10 79.45235
#> 11 80.45006
#> 12 80.84837
```

``` r
#example fo create plot
plot1 <- plot_sgstar(fit)
```
