% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapviz.R
\name{mshapviz}
\alias{mshapviz}
\title{Concatenates "shapviz" Objects}
\usage{
mshapviz(object, ...)
}
\arguments{
\item{object}{List of "shapviz" objects to be concatenated.}

\item{...}{Not used.}
}
\value{
A "mshapviz" object.
}
\description{
This function combines a list of "shapviz" objects to an object of class
"mshapviz". The elements can be named.
}
\examples{
S <- matrix(c(1, -1, -1, 1), ncol = 2, dimnames = list(NULL, c("x", "y")))
X <- data.frame(x = c("a", "b"), y = c(100, 10))
s1 <- shapviz(S, X, baseline = 4)[1L]
s2 <- shapviz(S, X, baseline = 4)[2L]
s <- mshapviz(c(shp1 = s1, shp2 = s2))
s
}
