% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_randomized_raster.R
\name{plot_randomized_raster}
\alias{plot_randomized_raster}
\title{plot_randomized_raster}
\usage{
plot_randomized_raster(raster, n = NULL, col, verbose = TRUE, nrow,
  ncol)
}
\arguments{
\item{raster}{List with randomized raster}

\item{n}{Number of randomized rasters to plot. See details for more information.}

\item{col}{Color palette used for plotting.}

\item{verbose}{Print messages.}

\item{nrow, ncol}{Number of rows and columns.}
}
\value{
plot
}
\description{
Plot randomized raster
}
\details{
Function to plot randomized rasters. If n is only a single number, n randomized
rasters will be sampled. If n is a vector, the corresponding rasters will be plotted.
}
\examples{
\dontrun{
landscape_classes <- classify_habitats(raster = landscape, classes = 5)
landscape_random <- randomize_raster(raster = landscape_classes, n_random = 19)

plot_randomized_raster(landscape_random)

palette <- viridis::viridis(n = 5)
plot_randomized_raster(landscape_random, n = 5, col = palette, nrow = 3, ncol = 2)
}

}
