% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rd_mar.R
\name{print.rd_mar}
\alias{print.rd_mar}
\title{print.rd_mar}
\usage{
\method{print}{rd_mar}(x, digits = 4, ...)
}
\arguments{
\item{x}{rd_mar object with randomized patterns.}

\item{digits}{Integer with number of decimal places (round) to be printed.}

\item{...}{Arguments passed to \code{cat}.}
}
\value{
void
}
\description{
Print method for rd_mar object
}
\details{
Printing method for random patterns created with \code{\link{reconstruct_pattern_marks}}.
}
\examples{
\dontrun{
pattern_recon <- reconstruct_pattern(species_a, n_random = 1, max_runs = 1000,
simplify = TRUE, return_input = FALSE)
marks_sub <- spatstat.geom::subset.ppp(species_a, select = dbh)
marks_recon <- reconstruct_pattern_marks(pattern_recon, marks_sub,
n_random = 19, max_runs = 1000)
print(marks_recon)
}

}
\seealso{
\code{\link{reconstruct_pattern_marks}}
}
