% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vizGeomorphicComponent.R
\name{vizGeomorphicComponent}
\alias{vizGeomorphicComponent}
\title{Visual Summary of Hill Landform Positions}
\usage{
vizGeomorphicComponent(
  x,
  s = NULL,
  annotations = TRUE,
  annotation.cex = 0.75,
  cols = c("#D53E4F", "#FC8D59", "#FEE08B", "#E6F598", "#99D594", "#3288BD"),
  ...
)
}
\arguments{
\item{x}{\code{data.frame} as created by \code{soilDB::fetchOSD(..., extended=TRUE)}, see details}

\item{s}{an optional soil series name, highlighted in the figure}

\item{annotations}{logical, add number of record and normalized Shannon entropy values}

\item{annotation.cex}{annotation label scaling factor}

\item{cols}{vector of colors}

\item{\dots}{additional arguments to \verb{[iterateHydOrder]}: \verb{target = 0.9, maxIter = 20, j.amount = 0.05, verbose = FALSE}}
}
\value{
A \code{list} with the following elements:
\itemize{
\item \code{fig}: lattice object (the figure)
\item \code{order}: 1D ordering from \code{cluster::diana}
\item \code{clust}: \code{hclust} object
\item \code{match.rate}: fraction of series matching target hydrologic ordering, after clustering + rotation
}
}
\description{
A unique display of landform position probability.
}
\details{
See the \href{http://ncss-tech.github.io/AQP/soilDB/soil-series-query-functions.html}{Soil Series Query Functions} tutorial for more information.
}
\author{
D.E. Beaudette
}
