% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{createMutabilityMatrix}
\alias{createMutabilityMatrix}
\title{Builds a mutability model}
\usage{
createMutabilityMatrix(db, substitutionModel, model = c("RS", "S"),
  sequenceColumn = "SEQUENCE_IMGT", germlineColumn = "GERMLINE_IMGT_D_MASK",
  vCallColumn = "V_CALL", multipleMutation = c("independent", "ignore"),
  minNumSeqMutations = 500, returnSource = FALSE)
}
\arguments{
\item{db}{data.frame containing sequence data.}

\item{substitutionModel}{matrix of 5-mer substitution rates built by 
\link{createSubstitutionMatrix}.}

\item{model}{type of model to create. The default model, "RS", creates 
a model by counting both replacement and silent mutations.
The "S" specification builds a model by counting only 
silent mutations.}

\item{sequenceColumn}{name of the column containing IMGT-gapped sample sequences.}

\item{germlineColumn}{name of the column containing IMGT-gapped germline sequences.}

\item{vCallColumn}{name of the column containing the V-segment allele call.}

\item{multipleMutation}{string specifying how to handle multiple mutations occuring 
within the same 5-mer. If \code{"independent"} then multiple 
mutations within the same 5-mer are counted indepedently. 
If \code{"ignore"} then 5-mers with multiple mutations are 
excluded from the total mutation tally.}

\item{minNumSeqMutations}{minimum number of mutations in sequences containing each 5-mer
to compute the mutability rates. If the number is smaller 
than this threshold, the mutability for the 5-mer will be 
inferred. Default is 500.}

\item{returnSource}{return the sources of 5-mer mutabilities (measured vs.
inferred). Default is false.}
}
\value{
A named numeric vector of 1024 normalized mutability rates for each 5-mer 
          motif with names defining the 5-mer nucleotide sequence.
}
\description{
\code{createMutabilityMatrix} builds a 5-mer nucleotide mutability model by counting 
the number of mutations occuring in the center position for all 5-mer motifs.
}
\examples{
# Subset example data to one isotype and sample as a demo
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, ISOTYPE == "IgA" & SAMPLE == "-1h")

# Create model using only silent mutations
sub_model <- createSubstitutionMatrix(db, model="S")
mut_model <- createMutabilityMatrix(db, sub_model, model="S")

}
\references{
\enumerate{
  \item  Yaari G, et al. Models of somatic hypermutation targeting and substitution based
           on synonymous mutations from high-throughput immunoglobulin sequencing data. 
           Front Immunol. 2013 4(November):358.
 }
}
\seealso{
\link{extendMutabilityMatrix}, \link{createSubstitutionMatrix}, 
          \link{createTargetingMatrix}, \link{createTargetingModel}
}

