% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_observations.R
\name{normalize_observations}
\alias{normalize_observations}
\title{Normalize observations}
\usage{
normalize_observations(data, response, grouping_var, ref_values)
}
\arguments{
\item{data}{input dataset to be plotted (required)}

\item{response}{response variable, Y (required)}

\item{grouping_var}{select grouping variable to normalize by (required)}

\item{ref_values}{add reference (nominal) values. takes a string of values with values appearing in the same order as in grouping variable. string length must be equal to unique values in grouping variable (required)}
}
\value{
A \code{tibble} object with observations normalized and saved in a new column.
}
\description{
This function takes an input dataset and normalizes observations
}
\examples{
library(dplyr)

polar_small_multiples_data \%>\%
    filter(ID_Measurement_Angle \%in\% c(0, 45, 90, 135)) \%>\%
    normalize_observations(response = ID,
                           grouping_var = Tip_Bottom,
                           ref_values = c(0.2075, 0.2225))

}
