% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{Overlay}
\alias{Overlay}
\title{Overlay}
\usage{
Overlay(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Overlays are used to render a semi-transparent layer on top of existing UI. Overlays help focus the user on the content that sits above the added layer and are often used to help designate a modal or blocking experience. Overlays can be seen used in conjunction with Panels and Dialogs.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Overlay}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item {\bold{ allowTouchBodyScroll }} {\code{boolean} \cr Allow body scroll on touch devices. Changing after mounting has no effect.}
\item {\bold{ className }} {\code{string} \cr Additional css class to apply to the Overlay}
\item {\bold{ componentRef }} {\verb{IRefObject<IOverlay>} \cr Gets the component ref.}
\item {\bold{ isDarkThemed }} {\code{boolean} \cr Whether to use the dark-themed overlay.}
\item {\bold{ onClick }} {\verb{() => void} \cr }
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<IOverlayStyleProps, IOverlayStyles>} \cr Call to provide customized styling that will layer on top of the variant rules}
\item {\bold{ theme }} {\code{ITheme} \cr Theme provided by HOC.}
}
}
\examples{
library(shiny.fluent)

if (interactive()) {
  shinyApp(
    ui = div(
      DefaultButton.shinyInput("toggleOverlay", text = "Open Overlay"),
      reactOutput("overlay")
    ),
    server = function(input, output) {
      show <- reactiveVal(FALSE)
      observeEvent(input$toggleOverlay, show(!show()))
      output$overlay <- renderReact({
        if (show()) {
          Overlay(
            onClick = JS("function() { Shiny.setInputValue('toggleOverlay', Math.random()); }"),
            isDarkThemed = TRUE,
            div(
              style="background: white; width: 50vw; height: 20rem; margin: auto;",
              div(
                style = "padding: 2rem;",
                h1("Inside Overlay"),
                p("Click anywhere to hide.")
              )
            )
          )
        }
      })
    }
  )
}
}
