% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/react.R
\name{reactElement}
\alias{reactElement}
\title{Create a 'React' element}
\usage{
reactElement(module, name, props, deps = NULL)
}
\arguments{
\item{module}{JavaScript module to import the component from.}

\item{name}{Name of the component.}

\item{props}{Props to pass to the component.}

\item{deps}{HTML dependencies to attach.}
}
\value{
A \code{shiny.tag} object representing the 'React' element.
}
\description{
Creates a \code{shiny.tag} which can be rendered just like other 'Shiny' tags as well as passed in
props to other 'React' elements. Typically returned from a wrapper ("component") function,
which parses its arguments with \code{asProps()} and fills in the other arguments.
}
\examples{
Component <- function(...) reactElement(
  module = "@/module", name = "Component", props = asProps(...)
)

}
\seealso{
\code{\link{asProps}}
}
