% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semantic_search.R
\name{search_selection_choices}
\alias{search_selection_choices}
\title{Add Semantic UI search selection dropdown based on provided choices}
\usage{
search_selection_choices(
  input_id,
  choices,
  value = NULL,
  multiple = FALSE,
  default_text = "Select",
  groups = NULL,
  dropdown_settings = list(forceSelection = FALSE)
)
}
\arguments{
\item{input_id}{Input name. Reactive value is available under input[[input_id]].}

\item{choices}{Vector or a list of choices to search through.}

\item{value}{String with default values to set when initialize the component.
Values should be delimited with a comma when multiple to set. Default NULL.}

\item{multiple}{TRUE if the dropdown should allow multiple selections,
FALSE otherwise (default FALSE).}

\item{default_text}{Text to be visible on dropdown when nothing is selected.}

\item{groups}{Vector of length equal to choices, specifying to which group the choice belongs.
Specifying the parameter enables group dropdown search implementation.}

\item{dropdown_settings}{Settings passed to dropdown() semantic-ui method.
See https://semantic-ui.com/modules/dropdown.html#/settings}
}
\description{
Define the (multiple) search selection dropdown input component serving
search options using provided choices.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
  library(shiny)
  library(shiny.semantic)

  ui <- function() {
    shinyUI(
      semanticPage(
        title = "Dropdown example",
        uiOutput("search_letters"),
        p("Selected letter:"),
        textOutput("selected_letters")
      )
    )
  }

  server <- shinyServer(function(input, output, session) {
    choices <- LETTERS
    output$search_letters <- shiny::renderUI(
      search_selection_choices("search_result", choices, multiple = TRUE)
    )
    output$selected_letters <- renderText(input[["search_result"]])
  })

  shinyApp(ui = ui(), server = server)
}
}
