% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-plot.R
\name{renderPlot}
\alias{renderPlot}
\title{Plot Output}
\usage{
renderPlot(expr, width = "auto", height = "auto", res = 72, ...,
  env = parent.frame(), quoted = FALSE, execOnResize = FALSE,
  outputArgs = list())
}
\arguments{
\item{expr}{An expression that generates a plot.}

\item{width, height}{The width/height of the rendered plot, in pixels; or
\code{'auto'} to use the \code{offsetWidth}/\code{offsetHeight} of the HTML
element that is bound to this plot. You can also pass in a function that
returns the width/height in pixels or \code{'auto'}; in the body of the
function you may reference reactive values and functions. When rendering an
inline plot, you must provide numeric values (in pixels) to both
\code{width} and \code{height}.}

\item{res}{Resolution of resulting plot, in pixels per inch. This value is
passed to \code{\link[grDevices]{png}}. Note that this affects the resolution of PNG
rendering in R; it won't change the actual ppi of the browser.}

\item{...}{Arguments to be passed through to \code{\link[grDevices]{png}}.
These can be used to set the width, height, background color, etc.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}

\item{execOnResize}{If \code{FALSE} (the default), then when a plot is
resized, Shiny will \emph{replay} the plot drawing commands with
\code{\link[grDevices]{replayPlot}()} instead of re-executing \code{expr}.
This can result in faster plot redrawing, but there may be rare cases where
it is undesirable. If you encounter problems when resizing a plot, you can
have Shiny re-execute the code on resize by setting this to \code{TRUE}.}

\item{outputArgs}{A list of arguments to be passed through to the implicit
call to \code{\link{plotOutput}} when \code{renderPlot} is used in an
interactive R Markdown document.}
}
\description{
Renders a reactive plot that is suitable for assigning to an \code{output}
slot.
}
\details{
The corresponding HTML output tag should be \code{div} or \code{img} and have
the CSS class name \code{shiny-plot-output}.
}
\section{Interactive plots}{


  With ggplot2 graphics, the code in \code{renderPlot} should return a ggplot
  object; if instead the code prints the ggplot2 object with something like
  \code{print(p)}, then the coordinates for interactive graphics will not be
  properly scaled to the data space.

  See \code{\link{plotOutput}} for more information about interactive plots.
}

\seealso{
For the corresponding client-side output function, and example
  usage, see \code{\link{plotOutput}}. For more details on how the plots are
  generated, and how to control the output, see \code{\link{plotPNG}}.
}
