% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{onStop}
\alias{onStop}
\title{Run code after an application or session ends}
\usage{
onStop(fun, session = getDefaultReactiveDomain())
}
\arguments{
\item{fun}{A function that will be called after the app has finished running.}

\item{session}{A scope for when the callback will run. If \code{onStop} is
called from within the server function, this will default to the current
session, and the callback will be invoked when the current session ends. If
\code{onStop} is called outside a server function, then the callback will
be invoked with the application exits. If \code{NULL}, it is the same as
calling \code{onStop} outside of the server function, and the callback will
be invoked when the application exits.}
}
\value{
A function which, if invoked, will cancel the callback.
}
\description{
This function registers callback functions that are invoked when the
application exits (when \code{\link[=runApp]{runApp()}} exits), or after each user
session ends (when a client disconnects).
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  # Open this application in multiple browsers, then close the browsers.
  shinyApp(
    ui = basicPage("onStop demo"),

    server = function(input, output, session) {
      onStop(function() cat("Session stopped\n"))
    },

    onStart = function() {
      cat("Doing application setup\n")

      onStop(function() {
        cat("Doing application cleanup\n")
      })
    }
  )
}
# In the example above, onStop() is called inside of onStart(). This is
# the pattern that should be used when creating a shinyApp() object from
# a function, or at the console. If instead you are writing an app.R which
# will be invoked with runApp(), you can do it that way, or put the onStop()
# before the shinyApp() call, as shown below.

\dontrun{
# ==== app.R ====
cat("Doing application setup\n")
onStop(function() {
  cat("Doing application cleanup\n")
})

shinyApp(
  ui = basicPage("onStop demo"),

  server = function(input, output, session) {
    onStop(function() cat("Session stopped\n"))
  }
)
# ==== end app.R ====


# Similarly, if you have a global.R, you can call onStop() from there.
# ==== global.R ====
cat("Doing application setup\n")
onStop(function() {
  cat("Doing application cleanup\n")
})
# ==== end global.R ====
}
}
\seealso{
\code{\link[=onSessionEnded]{onSessionEnded()}} for the same functionality, but at
the session level only.
}
