% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{rendering-custom-attrition}
\alias{rendering-custom-attrition}
\alias{.custom_attrition}
\title{Method for generating custom attrition output}
\usage{
.custom_attrition(source, ...)
}
\arguments{
\item{source}{Source object.}

\item{...}{Extra arguments passed to specific method.}
}
\value{
List of two objects: `render` and `output` defining rendering and
   output placeholder for custom attrition plot feature.
}
\description{
When method is defined for selected source, the output is displayed in attrition modal tab.
}
\details{
Similar to \link{.step_attrition} the method should return list of `render` and `output` expressions.
}
\examples{
if (interactive()) {
  library(magrittr)
  library(shiny)
  library(cohortBuilder)
  library(shinyCohortBuilder)

  .custom_attrition.tblist <- function(source, id, cohort, session, ...) {
    ns <- session$ns
    choices <- names(source$dtconn)

    list(
      render = shiny::renderPlot({
        cohort$show_attrition(dataset = session$input$attrition_input)
      }),
      output = shiny::tagList(
        shiny::h3("Step-wise Attrition Plot"),
        shiny::selectInput(ns("attrition_input"), "Choose dataset", choices),
        shiny::plotOutput(id)
      )
    )
  }
  coh <- cohort(
    set_source(as.tblist(librarian)),
    step(
      filter(
        "range", id = "copies", dataset = "books",
        variable = "copies", range = c(5, 12)
      )
    ),
    step(
      filter(
        "range", id = "copies", dataset = "books",
        variable = "copies", range = c(6, 8)
      )
    )
  ) \%>\% run()

  ui <- fluidPage(
    div(id = "attrition")
  )

  server <- function(input, output, session) {
    rendering <- .custom_attrition(
      coh$get_source(), id = "attr", cohort = coh, session = session, dataset = "books"
    )
    insertUI("#attrition", ui = rendering$output)
    output$attr <- rendering$render
  }

  shinyApp(ui, server)
}

}
\seealso{
\link{source-gui-layer}
}
