% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shine_coxph.R
\name{shine_coxph}
\alias{shine_coxph}
\title{Generates a shiny app for predictions from Cox model(s)}
\usage{
shine_coxph(..., app.dir = NULL, theme = c("default", "dashboard"))
}
\arguments{
\item{...}{Arbitrary number of Cox proportional hazard models, created by
\code{\link[survival:coxph]{survival::coxph()}} or \code{\link[=make_coxph]{make_coxph()}}, which automatically ensures the
models are appropriate for \code{shine_coxph()}}

\item{app.dir}{Directory where shiny app is created. Specifically, a
sub-folder will be made containing the \code{app.R} file as well as the \code{.Rdata}
file within \code{app.dir}. If no directory is provided, execution will pause
and the user will be asked to confirm whether this sub-folder may be
created in the working directory or to stop the function and provide an
input \code{app.dir}.}

\item{theme}{Theme of shiny app.
\itemize{
\item \verb{"default}: default theme, requires only shiny
\item \code{"dashboard"}: requires \code{"shinydashboard"} and \code{"DT"} packages
}}
}
\value{
A list containing Cox model information along with the shiny app
code. The app is written to the directory while the function is operating.
}
\description{
Writes a shiny app to visualize predicted survival curves from one or
multiple Cox models. One feature of this function is that
the shiny app, once created, will not contain any identifiable data,
containing only information necessary for predictions.
}
\section{Notes}{


There are some requirements in order for this function to run without
error: in your original \code{\link[survival:coxph]{survival::coxph()}} function or functions,
\code{model = TRUE} and \code{x = TRUE} are required arguments (used to create the
simplified \code{"coxph"} object). Currently, this function does not support
penalized models (e.g., as created by \code{ridge()} and \code{pspline()}). Multiple
strata terms and strata by covariate interaction terms in the formula are
also not currently supported, but workarounds are available by respectively
using a new strata factor variable encompassing all combinations of desired
stratum variable levels. Use of time-varying covariates (e.g. with \code{tt()})
and multi-state models is not supported in our function. The package is not
intended to support Fine-gray models by \code{\link[survival:finegray]{survival::finegray()}} creating Cox
models, but doing so will not result in an error.
}

\section{Guidelines}{


This package is intended to visualize and present predicted survival
functions for fitted Cox models. In regards to formula notation, the
variable names used are ultimately what will be displayed in the
application. Using functions in the formula will work, but with multiple
nested functions it will fail. Using "." notation is not currently
supported. The \code{na.action} is inherited from the Cox models, with \code{omit}
being the only option with support at this time. For these reasons, we
recommend creating all final variables (including suitable transformations)
with meaningful names prior to using \code{\link[survival:coxph]{survival::coxph()}}.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

  library(survival)

  # Data used is from survival package, renamed for legibility
  names(leukemia)[names(leukemia) == "x"] <- "treatment"
  # Make Cox model, with x = TRUE and model = TRUE
  model1 <- coxph(Surv(time, status) ~ treatment,
  leukemia, x = TRUE, model = TRUE)

  # Use shine_coxph() to create shiny app in temporary directory
  shine_coxph("Model 1" = model1)

  # Get directory for shiny app (should be first, check file list if not)
  filedir <- list.files(tempdir())[1]

  # Run shiny app from temporary directory
  shiny::runApp(paste0(tempdir(), "/", filedir))
  # Remove app from directory once finished
  unlink(paste0(tempdir(),"/",filedir), recursive = TRUE)

\dontshow{\}) # examplesIf}
}
