% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_downsampler.R
\docType{class}
\name{shiny_downsampler}
\alias{shiny_downsampler}
\title{R6 Class implementing down-sampling in shiny app}
\format{
An \code{R6::R6Class} object
}
\description{
This class includes original data, aggregation function(s) and plotly figure.
}
\examples{
\donttest{
library(plotly)
data(noise_fluct)
p <- plot_ly(noise_fluct) \%>\%
  add_trace(x = ~sec, y = ~level, type = "scatter", mode = "lines")
d_app <- shiny_downsampler$new(p)
d_app$show_shiny()
}
}
\section{Super class}{
\code{\link[shinyHugePlot:abstract_downsampler]{shinyHugePlot::abstract_downsampler}} -> \code{shiny_downsampler}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-shiny_downsampler-new}{\code{shiny_downsampler$new()}}
\item \href{#method-shiny_downsampler-cmpt_new_trace}{\code{shiny_downsampler$cmpt_new_trace()}}
\item \href{#method-shiny_downsampler-show_shiny}{\code{shiny_downsampler$show_shiny()}}
\item \href{#method-shiny_downsampler-clone}{\code{shiny_downsampler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="abstract_downsampler" data-id="add_trace"><a href='../../shinyHugePlot/html/abstract_downsampler.html#method-abstract_downsampler-add_trace'><code>shinyHugePlot::abstract_downsampler$add_trace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="abstract_downsampler" data-id="get_figure_data"><a href='../../shinyHugePlot/html/abstract_downsampler.html#method-abstract_downsampler-get_figure_data'><code>shinyHugePlot::abstract_downsampler$get_figure_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="abstract_downsampler" data-id="get_orig_data"><a href='../../shinyHugePlot/html/abstract_downsampler.html#method-abstract_downsampler-get_orig_data'><code>shinyHugePlot::abstract_downsampler$get_orig_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="abstract_downsampler" data-id="set_orig_data"><a href='../../shinyHugePlot/html/abstract_downsampler.html#method-abstract_downsampler-set_orig_data'><code>shinyHugePlot::abstract_downsampler$set_orig_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-shiny_downsampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-shiny_downsampler-new}{}}}
\subsection{Method \code{new()}}{
Create a new downsampler
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{shiny_downsampler$new(
  figure = plotly::plot_ly(),
  is_downsample = TRUE,
  n_out = 1000L,
  aggregator = eLTTB_aggregator$new(),
  legend_options = list(downsample_prefix = "<b style=\\"color:sandybrown\\">[R]</b> ",
    downsample_suffix = "", is_aggsize_shown = TRUE, agg_prefix =
    " <i style=\\"color:#fc9944\\">~", agg_suffix = "</i>"),
  tz = Sys.timezone()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{figure, is_downsample, n_out, aggregator, legend_options, tz}}{Arguments pass to the constructor of
the \code{abstract_downsampler} class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-shiny_downsampler-cmpt_new_trace"></a>}}
\if{latex}{\out{\hypertarget{method-shiny_downsampler-cmpt_new_trace}{}}}
\subsection{Method \code{cmpt_new_trace()}}{
update the trace data according to the relayout order.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{shiny_downsampler$cmpt_new_trace(relayout_order = list(), enforce = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{relayout_order}}{Named list.
The list generated by \code{plotlyjs_relayout},
which is obtained using \code{plotly::event_data}.}

\item{\code{enforce}}{Boolean.
It it is \code{TRUE}, the figure will be updated even if
\code{relayout_order} is \code{NULL}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-shiny_downsampler-show_shiny"></a>}}
\if{latex}{\out{\hypertarget{method-shiny_downsampler-show_shiny}{}}}
\subsection{Method \code{show_shiny()}}{
Easy output of the shiny app.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{shiny_downsampler$show_shiny(
  shiny_options = list(),
  width = "100\%",
  height = "600px"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{shiny_options}}{Named list.
Arguments passed to \code{shinyApp} as the options.}

\item{\code{width, height}}{Character, optional.
Arguments passed to \code{plotlyOutput}.
By default, \code{100\%} and \code{600px}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-shiny_downsampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-shiny_downsampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{shiny_downsampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
