% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_datahandler.R
\docType{class}
\name{plotly_datahandler}
\alias{plotly_datahandler}
\title{R6 class for handling plotly data}
\format{
An \code{R6::R6Class} object
}
\description{
A class for handling \code{plotly} data,
which defines functions used in the \code{downsampler} class
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{figure}}{\code{plotly} object.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{orig_data}}{Data frame representing \code{plotly} traces.}

\item{\code{trace_df_default}}{Data frame representing default values
of \code{plotly} traces.
\code{name} column represents the names of the attributes.
\code{required} column represents whether the attributes are necessary
to construct a data frame of a trace.
\code{data} column represents whether the attributes are the data.
\code{default} attributes represents default values of the attributes.
When constructing a data frame of a trace, default values are used
if no values are assigned.
\code{class} column represents the acceptable classes of the attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-plotly_datahandler-new}{\code{plotly_datahandler$new()}}
\item \href{#method-plotly_datahandler-set_trace_data}{\code{plotly_datahandler$set_trace_data()}}
\item \href{#method-plotly_datahandler-plotly_data_to_df}{\code{plotly_datahandler$plotly_data_to_df()}}
\item \href{#method-plotly_datahandler-clone}{\code{plotly_datahandler$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotly_datahandler-new"></a>}}
\if{latex}{\out{\hypertarget{method-plotly_datahandler-new}{}}}
\subsection{Method \code{new()}}{
Constructing an instance.
The data contained in a \code{plotly} object (\code{figure} argument)
will be included in the instance (as a reference).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotly_datahandler$new(
  figure = NULL,
  legend_options = list(name_prefix = "<b style=\\"color:sandybrown\\">[S]</b> ",
    name_suffix = "", xdiff_prefix = "<i style=\\"color:#fc9944\\"> ~", xdiff_suffix =
    "</i>"),
  tz = Sys.timezone(),
  use_light_build = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{figure}}{\code{plotly} object.
The traces of this object will be down-sampled.}

\item{\code{legend_options}}{Named list, optional.
Names of the elements are \code{name_prefix},
\code{name_suffix}, \code{xdiff_prefix},
and \code{xdiff_suffix}.
\code{name_prefix} and \code{name_suffix}
will be added to the name of the trace when the down-sampling is applied.
By default, prefix is a bold orange \code{[S]} and suffix is none.
\code{xdiff_prefix} and \code{xdiff_suffix} are employed to show
the mean aggregation size of the down-sampling.}

\item{\code{tz}}{Character, optional.
Time zone used to display time-series data.
By default \code{Sys.timezone()}.}

\item{\code{use_light_build}}{Boolean, optional.
Whether \code{plotly_build_light} is used.
It quickly build scatter-type \code{plotly} data.
By default, \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotly_datahandler-set_trace_data"></a>}}
\if{latex}{\out{\hypertarget{method-plotly_datahandler-set_trace_data}{}}}
\subsection{Method \code{set_trace_data()}}{
In the instance, data is contained as a data frame
(see \code{self$orig_data} for detailed information).
Using this method, the data can be added or overwritten.
If a data frame (\code{traces_df} argument) is given, it will be
added to \code{self$orig_data} or reassigned as \code{self$orig_data}.
If attributes to construct a \code{plotly} object (\code{...} argument)
are given, a data frame is constructed and used.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotly_datahandler$set_trace_data(..., traces_df = NULL, append = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments to constitute a \code{plotly} attributes, optional.
For instance, \code{x}, \code{y}, \code{type}, and \code{mode}
are applicable. See \code{plotly::plot_ly}.}

\item{\code{traces_df}}{Data frame, optional.
Data frame whose format is agreed with \code{self$orig_data}.
If \code{traces_df} is given, arguments in \code{...} are neglected.}

\item{\code{append}}{Boolean, optional.
Whether the data is append or overwrite. By default, \code{FALSE}
(the traces are overwritten).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotly_datahandler-plotly_data_to_df"></a>}}
\if{latex}{\out{\hypertarget{method-plotly_datahandler-plotly_data_to_df}{}}}
\subsection{Method \code{plotly_data_to_df()}}{
Covert the data contained in \code{plotly} object to a data frame.
A unique id (\code{uid}) is granted to each data.
The data frame will be returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotly_datahandler$plotly_data_to_df(plotly_data, use_datatable = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plotly_data}}{List.
The list whose elements are named list representing \code{plotly} traces.
All elements must have elements named \code{type}.}

\item{\code{use_datatable}}{Boolean.
If it is \code{TRUE}, data such as \code{x} and \code{y} are nested
in a \code{data.table}, of which key column is \code{x}.
By default, \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotly_datahandler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-plotly_datahandler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{plotly_datahandler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
