% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Panel.R
\name{updateF7Panel}
\alias{updateF7Panel}
\title{Function to programmatically update the state of a \link{f7Panel}}
\usage{
updateF7Panel(inputId, session)
}
\arguments{
\item{inputId}{Panel unique id. This is to access the input$id giving the panel
state, namely open or closed.}

\item{session}{Shiny session object.}
}
\description{
From open to close state and inversely
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shiny::shinyApp(
   ui = f7Page(
     title = "My app",
     init = f7Init(skin = "md", theme = "light"),
     f7SingleLayout(
       navbar = f7Navbar(
         title = "Single Layout",
         hairline = FALSE,
         shadow = TRUE,
         left_panel = TRUE,
         right_panel = TRUE
       ),
       panels = tagList(
         f7Panel(side = "left", inputId = "mypanel1", theme = "light", effect = "cover"),
         f7Panel(side = "right", inputId = "mypanel2", theme = "light")
       ),
       toolbar = f7Toolbar(
         position = "bottom",
         icons = TRUE,
         hairline = FALSE,
         shadow = FALSE,
         f7Link(label = "Link 1", src = "https://www.google.com"),
         f7Link(label = "Link 2", src = "https://www.google.com", external = TRUE)
       )
     )
   ),
   server = function(input, output, session) {

     observe({
       print(
         list(
           panel1 = input$mypanel1,
           panel2 = input$mypanel2
         )
       )
     })

     observe({
       invalidateLater(2000)
       updateF7Panel(inputId = "mypanel1", session = session)
     })

   }
 )
}
}
