% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Card.R
\name{f7Card}
\alias{f7Card}
\title{Create a Framework7 card}
\usage{
f7Card(
  ...,
  img = NULL,
  title = NULL,
  footer = NULL,
  outline = FALSE,
  height = NULL
)
}
\arguments{
\item{...}{Card content.}

\item{img}{Card image if any. Displayed in the header.}

\item{title}{Card title.}

\item{footer}{Footer content, if any. Must be wrapped in a tagList.}

\item{outline}{Outline style. FALSE by default.}

\item{height}{Card height. NULL by default.}
}
\description{
Build a Framework7 card
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
  ui = f7Page(
    title = "Cards",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Card"),
     f7Card("This is a simple card with plain text,
    but cards can also contain their own header,
    footer, list view, image, or any other element."),
    f7Card(
     title = "Card header",
     "This is a simple card with plain text,
     but cards can also contain their own header,
     footer, list view, image, or any other element.",
     footer = tagList(
      f7Button(color = "blue", label = "My button", src = "https://www.google.com"),
      f7Badge("Badge", color = "green")
     )
    ),
    f7Card(
     title = "Card header",
     img = "https://lorempixel.com/1000/600/nature/3/",
     "This is a simple card with plain text,
     but cards can also contain their own header,
     footer, list view, image, or any other element.",
     footer = tagList(
      f7Button(color = "blue", label = "My button", src = "https://www.google.com"),
      f7Badge("Badge", color = "green")
     )
    )
    )
  ),
  server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
