% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Progress.R
\name{f7Progress}
\alias{f7Progress}
\alias{updateF7Progress}
\title{Framework7 progress bar}
\usage{
f7Progress(id, value = NULL, color)

updateF7Progress(id, value, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{id}{Unique progress bar id.}

\item{value}{New value.}

\item{color}{Progress color. See \url{https://framework7.io/docs/progressbar.html}.}

\item{session}{Shiny session object.}
}
\description{
\code{f7Progress} creates a progress bar.

\code{updateF7Progress} update a framework7 progress bar from the server side
}
\examples{
# Progress bars
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
    title = "Progress",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Progress"),
     f7Block(f7Progress(id = "pg1", value = 10, color = "pink")),
     f7Block(f7Progress(id = "pg2", value = 100, color = "green")),
     f7Block(f7Progress(id = "pg3", value = 50, color = "orange"))
    )
   ),
   server = function(input, output) {}
 )
}

# Update progress
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "Update Progress",
     f7SingleLayout(
       navbar = f7Navbar(title = "f7Progress"),
       f7Block(
         f7Progress(id = "pg1", value = 10, color = "blue")
       ),
       f7Slider(
         inputId = "obs",
         label = "Progress value",
         max = 100,
         min = 0,
         value = 50,
         scale = TRUE
       )
     )
   ),
   server = function(input, output, session) {
     observeEvent(input$obs, {
       updateF7Progress(id = "pg1", value = input$obs)
     })
   }
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
