% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Swipeout.R
\name{f7Swipeout}
\alias{f7Swipeout}
\alias{f7SwipeoutItem}
\title{Framework7 swipeout element}
\usage{
f7Swipeout(
  tag,
  ...,
  left = NULL,
  right = NULL,
  side = c("left", "right", "both")
)

f7SwipeoutItem(id, label, color = NULL)
}
\arguments{
\item{tag}{Tag to be swiped.}

\item{...}{When side is either "right" or "left" use this slot to pass
\link{f7SwipeoutItem}.}

\item{left}{When side is "both", put the left \link{f7SwipeoutItem}.}

\item{right}{When side is "both", put the right \link{f7SwipeoutItem}.}

\item{side}{On which side to swipe: "left", "right" or "both".}

\item{id}{Item unique id.}

\item{label}{Item label.}

\item{color}{Item color.}
}
\description{
\code{f7Swipeout} is designed to be used in combination with \link{f7ListItem}.

\code{f7SwipeoutItem} is inserted in \link{f7Swipeout}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "Swipeout",
     f7SingleLayout(
       navbar = f7Navbar(title = "Swipeout"),
       # simple list
       f7List(
         lapply(1:3, function(j) {
           if (j == 1) {
             f7Swipeout(
               tag = f7ListItem(letters[j]),
               side = "left",
               f7SwipeoutItem(id = "alert", color = "pink", "Alert"),
               f7SwipeoutItem(id = "notification", color = "green", "Notif")
             )
           } else {
             f7ListItem(letters[j])
           }
         })
       )
     )
   ),
   server = function(input, output, session) {
     observe({
       print(input$alert)
       print(input$notification)
     })

     observeEvent(input$notification, {
       f7Notif(
         text = "test",
         icon = f7Icon("bolt_fill"),
         title = "Notification",
         subtitle = "A subtitle",
         titleRightText = "now"
       )
     })

     observeEvent(input$alert, {
       f7Dialog(
         title = "Dialog title",
         text = "This is an alert dialog"
       )
     })

   }
 )
}
}
