% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel.R
\name{panel}
\alias{panel}
\title{Create a panel}
\usage{
panel(..., heading = NULL, footer = NULL, status = "default")
}
\arguments{
\item{...}{UI elements to include inside the panel.}

\item{heading}{Title for the panel in a plain header.}

\item{footer}{Footer for the panel.}

\item{status}{Bootstrap status for contextual alternative.}
}
\value{
A UI definition.
}
\description{
Create a panel (box) with basic border and padding,
you can use Bootstrap status to style the panel,
see \url{http://getbootstrap.com/components/#panels}.
}
\examples{
\dontrun{

if (interactive()) {
library("shiny")
library("shinyWidgets")

ui <- fluidPage(

  # Default
  panel(
    "Content goes here",
    checkboxInput(inputId = "id1", label = "Label")
  ),

  # With header and footer
  panel(
    "Content goes here",
    checkboxInput(inputId = "id2", label = "Label"),
    heading = "My title",
    footer = "Something"
  ),

  # With status
  panel(
    "Content goes here",
    checkboxInput(inputId = "id3", label = "Label"),
    heading = "My title",
    status = "primary"
  )
)

server <- function(input, output, session) {

}

shinyApp(ui = ui, server = server)
}

}
}
