% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actionBttn.R
\name{actionBttn}
\alias{actionBttn}
\title{Awesome action button}
\usage{
actionBttn(
  inputId,
  label = NULL,
  icon = NULL,
  style = "unite",
  color = "default",
  size = "md",
  block = FALSE,
  no_outline = TRUE,
  ...
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{The contents of the button, usually a text label.}

\item{icon}{An optional icon to appear on the button.}

\item{style}{Style of the button, to choose between \code{simple}, \code{bordered},
\code{minimal}, \code{stretch}, \code{jelly}, \code{gradient}, \code{fill},
\code{material-circle}, \code{material-flat}, \code{pill}, \code{float}, \code{unite}.}

\item{color}{Color of the button : \code{default}, \code{primary}, \code{warning},
\code{danger}, \code{success}, \code{royal}.}

\item{size}{Size of the button : \code{xs},\code{sm}, \code{md}, \code{lg}.}

\item{block}{Logical, full width button.}

\item{no_outline}{Logical, don't show outline when navigating with
keyboard/interact using mouse or touch.}

\item{...}{Other arguments to pass to the container tag function.}
}
\description{
Like \code{\link[shiny:actionButton]{shiny::actionButton()}} but awesome, via \url{https://bttn.surge.sh/}
}
\examples{
if (interactive()) {

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h2("Awesome action button"),
  tags$br(),
  actionBttn(
    inputId = "bttn1",
    label = "Go!",
    color = "primary",
    style = "bordered"
  ),
  tags$br(),
  verbatimTextOutput(outputId = "res_bttn1"),
  tags$br(),
  actionBttn(
    inputId = "bttn2",
    label = "Go!",
    color = "success",
    style = "material-flat",
    icon = icon("sliders"),
    block = TRUE
  ),
  tags$br(),
  verbatimTextOutput(outputId = "res_bttn2")
)

server <- function(input, output, session) {
  output$res_bttn1 <- renderPrint(input$bttn1)
  output$res_bttn2 <- renderPrint(input$bttn2)
}

shinyApp(ui = ui, server = server)

}
}
\seealso{
\code{\link[=downloadBttn]{downloadBttn()}}
}
