% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-icon.R
\name{textInputIcon}
\alias{textInputIcon}
\title{Create a text input control with icon(s)}
\usage{
textInputIcon(
  inputId,
  label,
  value = "",
  placeholder = NULL,
  icon = NULL,
  size = NULL,
  width = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value.}

\item{placeholder}{A character string giving the user a hint as to what can
be entered into the control. Internet Explorer 8 and 9 do not support this
option.}

\item{icon}{An \code{\link[shiny:icon]{shiny::icon()}} (or equivalent) or a \code{list}, containing \code{icon}s
or text, to be displayed on the right or left of the text input.}

\item{size}{Size of the input, default to \code{NULL}, can
be \code{"sm"} (small) or \code{"lg"} (large).}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}
}
\value{
A text input control that can be added to a UI definition.
}
\description{
Extend form controls by adding text or icons before,
after, or on both sides of a classic \code{textInput}.
}
\examples{
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  # Test with different version of Bootstrap
  theme = bslib::bs_theme(version = 5),

  tags$h2("textInputIcon examples"),
  fluidRow(
    column(
      width = 6,
      textInputIcon(
        inputId = "ex1",
        label = "With an icon",
        icon = icon("circle-user")
      ),
      verbatimTextOutput("res1"),
      textInputIcon(
        inputId = "ex2",
        label = "With an icon (right)",
        icon = list(NULL, icon("circle-user"))
      ),
      verbatimTextOutput("res2"),
      textInputIcon(
        inputId = "ex3",
        label = "With text",
        icon = list("https://")
      ),
      verbatimTextOutput("res3"),
      textInputIcon(
        inputId = "ex4",
        label = "Both side",
        icon = list(icon("envelope"), "@mail.com")
      ),
      verbatimTextOutput("res4"),
      textInputIcon(
        inputId = "ex5",
        label = "Sizing",
        icon = list(icon("envelope"), "@mail.com"),
        size = "lg"
      ),
      verbatimTextOutput("res5")
    )
  )
)

server <- function(input, output, session) {

  output$res1 <- renderPrint(input$ex1)
  output$res2 <- renderPrint(input$ex2)
  output$res3 <- renderPrint(input$ex3)
  output$res4 <- renderPrint(input$ex4)
  output$res5 <- renderPrint(input$ex5)

}

if (interactive())
  shinyApp(ui, server)
}
\seealso{
See \code{\link[=updateTextInputIcon]{updateTextInputIcon()}} to update server-side, and \code{\link[=numericInputIcon]{numericInputIcon()}} for using numeric value.
}
