% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launch_shinybrms.R
\name{launch_shinybrms}
\alias{launch_shinybrms}
\title{Launch the \pkg{shinybrms} Shiny app}
\usage{
launch_shinybrms(launch.browser = interactive(), ...)
}
\arguments{
\item{launch.browser}{Argument \code{launch.browser} from \code{\link[shiny:runApp]{shiny::runApp()}}. Defaults here to
\code{interactive()}.}

\item{\dots}{Further arguments passed to \code{\link[shiny:runApp]{shiny::runApp()}}. For example, in order to force
launching the Shiny app in the system's default web browser, set argument \code{launch.browser} to
\code{TRUE}.}
}
\value{
\code{TRUE} (invisible).
}
\description{
This function launches the \pkg{shinybrms} Shiny app.
}
\note{
If option \code{mc.cores} is set, then the advanced option "Cores" defaults to the value of this
option. If option \code{mc.cores} is not set, then the advanced option "Cores" defaults to the value
returned by \code{\link[parallel:detectCores]{parallel::detectCores()}}.

By default, the \href{https://mc-stan.org/}{Stan} progress automatically opens up as an HTML file.
This behavior may be disabled in the "Advanced options" of the \pkg{shinybrms} Shiny app
(option "Open progress"), but for the remainder of this paragraph, it is assumed that the
automatic opening of the Stan progress file is desired. In RStudio, the default for option
\code{browser} cannot be used for the Stan progress file. Therefore, \pkg{shinybrms} has an option
\code{shinybrms.browser_RStudio} specifying the value for option \code{browser} to be used when running
in RStudio. If not specified, option \code{shinybrms.browser_RStudio} defaults to \code{NULL}. On
Windows, \code{NULL} means that the default browser (as determined by the file association
mechanism) is used. On non-Windows systems, \code{NULL} has no meaning and automatically disables
the advanced option "Open progress" from the \pkg{shinybrms} app internally (with a
notification popping up) if not done by the user. On any system, option
\code{shinybrms.browser_RStudio} may directly specify the HTML browser to use (see argument
\code{browser} in \code{\link[utils:browseURL]{utils::browseURL()}} and option \code{browser} in \code{\link[base:options]{base::options()}} for details).

The option \code{shinybrms.browser_RStudio} (see above) is also used when launching the
\pkg{shinystan} Shiny app and running in RStudio. Here, the default (\code{NULL}) makes it
impossible to launch the \pkg{shinystan} app if running on a non-Windows system (and in
RStudio).
}
\examples{
\donttest{
launch_shinybrms()
}
}
