% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recorder.R
\name{recordTest}
\alias{recordTest}
\title{Launch test event recorder for a Shiny app}
\usage{
recordTest(app = ".", save_dir = NULL, load_mode = FALSE,
  seed = NULL, loadTimeout = 10000, debug = "shiny_console",
  shinyOptions = list())
}
\arguments{
\item{app}{A \code{\link{ShinyDriver}} object, or path to a Shiny
application.}

\item{save_dir}{A directory to save stuff.}

\item{load_mode}{A boolean that determines whether or not the resulting test
script should be appropriate for load testing.}

\item{seed}{A random seed to set before running the app. This seed will also
be used in the test script.}

\item{loadTimeout}{Maximum time to wait for the Shiny application to load, in
milliseconds. If a value is provided, it will be saved in the test script.}

\item{debug}{start the underlying \code{\link{ShinyDriver}} in \code{debug}
mode and print those debug logs to the R console once recording is
finished. The default, \code{'shiny_console'}, captures and prints R
console output from the recorded R shiny process. Any value that the
\code{debug} argument in \code{\link{ShinyDriver}} accepts may be used
(e.g., \code{'none'} may be used to completely suppress the driver logs).}

\item{shinyOptions}{A list of options to pass to \code{runApp()}. If a value
is provided, it will be saved in the test script.}
}
\description{
Launch test event recorder for a Shiny app
}
