#
#   shopifyr: An R Interface to the Shopify API
#
#   Copyright (C) 2015 Charlie Friedemann cfriedem @ gmail.com
#   Shopify API (c) 2006-2015 Shopify Inc.
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

########### ApplicationCharge functions ########### 
#' @templateVar name ApplicationCharge
#' @templateVar slug charge
#' @templateVar article an
#' @templateVar urlSlug billing/applicationcharge
#' @template api
NULL

## POST /admin/api/#{api_version}/application_charges.json
## Creates an application charge
#' @rdname ApplicationCharge
createApplicationCharge <- function(charge, ...) {
    charge <- private$.wrap(charge, "application_charge", check=FALSE)
    private$.request("application_charges", reqType="POST", data=charge, ...)$application_charge
}

## GET /admin/api/#{api_version}/application_charges/#{application_charge_id}.json
## Retrieves an application charge
#' @rdname ApplicationCharge
getApplicationCharge <- function(chargeId, ...) {
    private$.request(private$.url("application_charges",chargeId), ...)$application_charge
}

## GET /admin/api/#{api_version}/application_charges.json
## Retrieves a list of application charges
#' @rdname ApplicationCharge
getApplicationCharges <- function(...) {
    private$.request("application_charges", ...)$application_charges
}

## POST /admin/api/#{api_version}/application_charges/#{application_charge_id}/activate.json
## Activates an application charge
#' @rdname ApplicationCharge
activateApplicationCharge <- function(charge, ...) {
    charge <- private$.wrap(charge, "application_charge")
    private$.request(private$.url("application_charges",charge$application_charge$id), reqType="POST", data=charge, ...)$application_charge
}