% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_target_location.R
\name{check_target_location}
\alias{check_target_location}
\title{Check if a target site is set to the correct CRS and is located within the
spatial limit}
\usage{
check_target_location(target)
}
\arguments{
\item{target}{A spatial object of class \code{sf}, representing a site location.}
}
\value{
A warning if the target does not intersect the study area. An error
if it is lacking or is set to the incorrect coordinate reference system.
}
\description{
Checks if a target site is set to the correct coordinate reference system
WGS84 UTM32N (EPSG: 32632). Throws an error if this is not the case. Checks
if the location intersects the study area for which the method was derived
(see Roalkvam 2022). Returns a warning if this is not the case.
}
\examples{
# Create example point using the required coordinate system
# WGS84 UTM32N (EPSG: 32632)
target_point <- sf::st_sfc(sf::st_point(c(579570, 6582982)), crs = 32632)

# Check the CRS and the location of the site
check_target_location(target_point)

}
