% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_using_instant_velocity.R
\name{model_using_instant_velocity}
\alias{model_using_instant_velocity}
\title{Model Using Instantaneous Velocity}
\usage{
model_using_instant_velocity(
  time,
  velocity,
  time_delay = 0,
  weights = 1,
  na.rm = FALSE
)
}
\arguments{
\item{time}{Numeric vector}

\item{velocity}{Numeric vector}

\item{time_delay}{Numeric vector. Used to filter out noisy data from the radar gun. Default is 0. See more
in Samozino (2018)}

\item{weights}{Numeric vector. Default is 1}

\item{na.rm}{Logical. Default is FALSE}
}
\value{
List object with the following elements:
    \describe{
        \item{parameters}{List with the following estimated parameters:
            \code{MSS}, \code{TAU}, \code{MAC}, and \code{PMAX}}
        \item{model_fit}{List with the following components:
            \code{RSE}, \code{R_squared}, \code{minErr}, \code{maxErr},
            \code{maxAbsErr}, and \code{RMSE}}
        \item{model}{Model returned by the \code{\link[stats]{nls}} function}
        \item{data}{Data frame used to estimate the sprint parameters, consisting of \code{time},
            \code{velocity}, \code{time_delay}, \code{weights}, and \code{pred_velocity} columns}
        }
}
\description{
This function models the sprint instantaneous velocity using mono-exponential equation that estimates
    maximum sprinting speed (\code{MSS}) and relative acceleration (\code{TAU}). \code{velocity} is used as target or outcome
    variable, and \code{time} as predictor.
}
\examples{
instant_velocity <- data.frame(
time = c(0, 1, 2, 3, 4, 5, 6),
velocity = c(0.00, 4.99, 6.43, 6.84, 6.95, 6.99, 7.00)
)

sprint_model <- with(
  instant_velocity,
  model_using_instant_velocity(time, velocity)
)

sprint_model$parameters
}
\references{
Samozino P. 2018. A Simple Method for Measuring Force, Velocity and Power Capabilities and Mechanical
        Effectiveness During Sprint Running. In: Morin J-B, Samozino P eds. Biomechanics of Training and Testing.
       Cham: Springer International Publishing, 237–267. DOI: 10.1007/978-3-319-05633-3_11.
}
