% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{TV_heatmap}
\alias{TV_heatmap}
\title{Heatmap of hyperparameters of time-varying coefficient matrix in a TVP-VAR model}
\usage{
TV_heatmap(x, cuts = 15, cols, max_val, flipcols, ...)
}
\arguments{
\item{x}{\code{mcmc.var} object}

\item{cuts}{single integer value, determining the number of cuts for the color palette.
The default value is 15.}

\item{cols}{character string, determining the color palette to be used. The default value is "Purples" for \code{theta_sr}
and "RdBu" for all others. See \code{RColorBrewer::brewer.pal.info} for more information.}

\item{max_val}{numeric value, determining the maximum value for the color palette.
If missing, the maximum value is determined by the largest absolute value of the data.}

\item{flipcols}{logical value, determining whether the color palette should be flipped. The default value is \code{FALSE} for
\code{theta_sr} and \code{TRUE} for all others.}

\item{...}{further arguments to be passed to \code{lattice::levelplot}.}
}
\value{
Called for its side effects and returns invisibly.
}
\description{
\code{TV_heatmap} plots a heatmap of  posterior distribution for hyperparameters
of a time-varying parameter coefficient matrix in a TVP-VAR model. This is achieved
by plotting the median of the posterior of the absolute value for \code{theta_sr} and the
median of the posterior for all others. The plot itself is generated by
\code{lattice::levelplot}.
\code{beta_mean} and \code{theta_sr} will most likely be of interest here.
}
\examples{
\donttest{
set.seed(123)
sim <- simTVPVAR(p = 2)
data <- sim$data

res <- shrinkTVPVAR(data, p = 2)
TV_heatmap(res$theta_sr)
}
}
\seealso{
Other plotting functions: 
\code{\link{density_plotter}()},
\code{\link{plot.mcmc.tvp.var}()},
\code{\link{plot.mcmc.var}()},
\code{\link{plot.shrinkTVPVAR}()},
\code{\link{plot.shrinkTVPVAR_fit}()},
\code{\link{plot.shrinkTVPVAR_forc}()},
\code{\link{state_plotter}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{plotting functions}
