% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterCalculation.R
\name{parameterCalculation}
\alias{parameterCalculation}
\title{useful paramter calculation with help of fits}
\usage{
parameterCalculation(parameterVector, stepSize = 1e-05)
}
\arguments{
\item{parameterVector}{Output of multiple fit function sicegar::multipleFitFunction() that gives the variables related with sigmoidal or double sigmoidal fit.}

\item{stepSize}{Step size used by the fitting algorithm. Smaller numbers gave more accurate results than larger numbers, and larger numbers gave the results faster than small numbers. The default value is 0.00001.}
}
\value{
Returns the expanded parameter vector. This vector includes useful derived values such as time and intensity of the start point, in addition to the standard values that the fit algorithms produce that are necessary to define the curves.
}
\description{
Generates useful values for external use, with the help of parameterVector's of the fits.
}
\examples{
time <- seq(3, 24, 0.1)

#simulate intensity data with noise
noise_parameter <- 0.2
intensity_noise <- stats::runif(n = length(time), min = 0, max = 1) * noise_parameter
intensity <- sicegar::doublesigmoidalFitFormula(time,
                                            finalAsymptoteIntensityRatio = .3,
                                            maximum = 4,
                                            slope1Param = 1,
                                            midPoint1Param = 7,
                                            slope2Param = 1,
                                            midPointDistanceParam = 8)
intensity <- intensity+intensity_noise

dataInput <- data.frame(intensity = intensity, time = time)
normalizedInput <- sicegar::normalizeData(dataInput)
parameterVector <- sicegar::multipleFitFunction(dataInput = normalizedInput,
                                            dataInputName = "sample01",
                                            model = "doublesigmoidal",
                                            n_runs_min = 20,
                                            n_runs_max = 500,
                                            showDetails = FALSE)

if(parameterVector$isThisaFit){
       parameterVector <- sicegar::parameterCalculation(parameterVector)
}

print(t(parameterVector))

}
