% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sidra.R
\name{get_sidra}
\alias{get_sidra}
\title{Get SIDRA's table}
\usage{
get_sidra(x, variable = "allxp", period = "last", geo = "Brazil",
  geo.filter = NULL, classific = "all", category = "all", header = TRUE,
  format = 4, digits = "default", api = NULL)
}
\arguments{
\item{x}{A table from IBGE's SIDRA API.}

\item{variable}{An integer vector of the variables' codes to be returned.
Defaults to all variables with exception of "Total".}

\item{period}{A character vector describing the period of data. Defaults to
the last available.}

\item{geo}{A character vector describing the geographic levels of the data.
Defauts to "Brazil".}

\item{geo.filter}{A (named) list object with the specific item of the
geographic level or all itens of a determined higher geografic level. It should
be used when geo argument is provided, otherwise all geographic units of
'geo' argument are considered.}

\item{classific}{A character vector with the table's classification(s). Defaults to
all.}

\item{category}{"all" or a list object with the categories of the classifications
of \code{classific(s)} argument. Defaults to "all".}

\item{header}{Logical. should the data frame be returned with the description
names in header?}

\item{format}{An integer ranging between 1 and 4. Default to 4. See more in details.}

\item{digits}{An integer, "default" or "max". Default to "default" that returns the
defaults digits to each variable.}

\item{api}{A character element with the api's parameters. Defaults to NULL.}
}
\value{
The function returns a data frame printed by default functions
}
\description{
This function allows the user to connect with IBGE's (Instituto Brasileiro de
Geografia e Estatistica) SIDRA API in a flexible way. \acronym{SIDRA} is the
acronym to "Sistema IBGE de Recuperacao Automatica" and it is the system where
IBGE makes aggregate data from their researches available.
}
\details{
\code{period} can be a integer vector with names "first" and/or "last",
  or "all" or a simply character vector with date format %Y%m-%Y%m.

  The \code{geo} argument can be one of "Brazil", "Region", "State",
  "MesoRegion", "MicroRegion", "MetroRegion", "MetroRegionDiv", "IRD",
  "UrbAglo", "City", "District","subdistrict","Neighborhood","PopArrang".
  'geo.filter' lists can/must be named with the same characters.

  When NULL, the arguments \code{classific} and \code{category} return all options
  available.
  
  When argument \code{api} is not NULL, all others arguments informed are desconsidered

  The \code{format} argument can be set to:
  \itemize{
     \item 1: Return only the descriptors' codes
     \item 2: Return only the descriptor's names
     \item 3: Return the codes and names of the geographic level and descriptors' names
     \item 4: Return the codes and names of the descriptors (Default)
     }
}
\examples{
\dontrun{
## Requesting table 1419 (Consumer Price Index - IPCA) from the API
ipca <- get_sidra(1419,
                  variable = 69,
                  period = c("201212","201401-201412"),
                  geo = "City",
                  geo.filter = list("State" = 50))

## Urban population count from Census data (2010) for States and cities of Southest region.
get_sidra(1378,
          variable = 93,
          geo = c("State","City"),
          geo.filter = list("Region" = 3, "Region" = 3),
          classific = c("c1"),
          category = list(1))
 
## Number of informants by state in the Inventory Research (last data available) 
get_sidra(api = "/t/254/n1/all/n3/all/v/151/p/last\%201/c162/118423/c163/0")

}

}
\seealso{
\code{\link{info_sidra}}
}
\author{
Renato Prado Siqueira \email{<rpradosiqueira@gmail.com>}
}
\keyword{IBGE}
\keyword{sidra}
