% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmaAttrs.R
\name{saveSigma}
\alias{saveSigma}
\title{Save 'sigmaNet' object as html - a wrapper for saveWidget()}
\usage{
saveSigma(sigmaObj, fileName = NULL)
}
\arguments{
\item{sigmaObj}{A 'sigmaNet' object - created using the 'sigmaFromIgraph' function}

\item{fileName}{A name for your html output (with or without .html at the end)}
}
\value{
An html file in your working directory (or other specified directory).  This file is a
  standalone representation of your 'Sigma.js' visualization that can be shared and moved freely.
  This object will maintain it's interactivity.
}
\description{
Save an 'sigmaNet' object as an html file (without rendering it).  This is especially helpful
when dealing with very large graphs that could crash your R session if you attempt to render
them in the 'Rstudio' viewer pane.
}
\examples{
library(igraph)
library(sigmaNet)
library(magrittr)

data(lesMis)

l <- layout_nicely(lesMis)
sig <- sigmaFromIgraph(graph = lesMis, layout = l)

\dontrun{
saveSigma(sig, fileName = file.path(tempdir(), 'myFile.html'))
}

}
