% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{sg_progress}
\alias{sg_progress}
\title{Text}
\usage{
sg_progress(sg, data, delay, text, ..., position = "top", id = NULL,
  tag = htmltools::span, cumsum = TRUE)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{data}{Data.frame holding \code{delay} and \code{text}.}

\item{delay}{Delay, in milliseconds at which text should appear.}

\item{text}{Text to appear on graph.}

\item{...}{Content of the button, complient with \code{htmltools}.}

\item{position}{Position of button, \code{top} or \code{bottom}.}

\item{id}{A valid CSS id.}

\item{tag}{A Valid \link[htmltools]{tags} function.}

\item{cumsum}{Whether to compute the cumulative sum on the \code{delay}.}
}
\description{
Add text to your graph.
}
\details{
The \code{element} is passed to \href{https://developer.mozilla.org/en-US/docs/Web/API/Document/createElement}{Document.createElement()}
and therefore takes any valid \code{tagName}, including, but not limited to; \code{p}, \code{h1}, \code{div}.
}
\examples{
# initial nodes
nodes <- sg_make_nodes()

# additional nodes
nodes2 <- sg_make_nodes()
nodes2$id <- as.character(seq(11, 20))

# add delay
nodes2$delay <- runif(nrow(nodes2), 500, 1000)
nodes2$text <- seq.Date(Sys.Date(), Sys.Date() + 9, "days")

sigmajs() \%>\%
  sg_nodes(nodes, id, label, size, color) \%>\%
  sg_add_nodes(nodes2, delay, id, label, size, color) \%>\% 
  sg_progress(nodes2, delay, text, element = "h3") \%>\%
  sg_button(c("add_nodes", "progress"), "add") 

}
