% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_series.R
\name{draw_subtypes_comparison}
\alias{draw_subtypes_comparison}
\title{Plot comparison between signature subtypes}
\usage{
draw_subtypes_comparison(subtype_summary, xlab = "subtype",
  ylab_co = NA, legend_title_ca = NA, show_pvalue = TRUE, ...)
}
\arguments{
\item{subtype_summary}{a \code{list} from result of \link{sig_summarize_subtypes} function.}

\item{xlab}{lab name of x axis for all plots.}

\item{ylab_co}{lab name of y axis for plots of continuous type data. Of note,
this argument should be a character vector has same length as \code{subtype_summary},
the location for categorical type data should mark with \code{NA}.}

\item{legend_title_ca}{legend title for plots of categorical type data.
Of note,
this argument should be a character vector has same length as \code{subtype_summary},
the location for continuous type data should mark with \code{NA}.}

\item{show_pvalue}{if \code{TRUE}, show p value for comparison of continuous data types.}

\item{...}{other paramters pass to \code{\link[ggpubr:stat_compare_means]{ggpubr::stat_compare_means()}}.}
}
\value{
a \code{list} of \code{ggplot} objects.
}
\description{
Using result data from \link{sig_summarize_subtypes} function, this function plot
genotypes/phenotypes comparison between signature subtypes using \strong{ggplot2} package and return
a list of \code{ggplot} object contains individual and combined plots. The combined
plot is easily saved to local using \code{\link[cowplot:save_plot]{cowplot::save_plot()}}.
}
\examples{
# Load copy number signature
load(system.file("extdata", "toy_copynumber_signature.RData",
  package = "sigminer", mustWork = TRUE
))
# Assign samples to clusters
subtypes <- sig_assign_samples(res$nmfObj, type = "samples")

set.seed(1234)
# Add custom groups
subtypes$new_group <- sample(c("1", "2", "3", "4"), size = nrow(subtypes), replace = TRUE)
# Summarize subtypes
subtypes.sum <- sig_summarize_subtypes(subtypes[, -1],
  col_subtype = "nmf_subtypes",
  cols_to_summary = colnames(subtypes[, -1])[c(-1, -2)],
  type = c("co", "ca"), verbose = TRUE
)
draw_subtypes_comparison(subtypes.sum)
}
\seealso{
Other signature plot: \code{\link{draw_sig_activity}},
  \code{\link{draw_sig_corrplot}},
  \code{\link{draw_sig_profile}}
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
\concept{signature plot}
