% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series.R
\name{get_components}
\alias{get_components}
\title{Fit optimal number of mixture model components}
\usage{
get_components(CN_features, seed = 123456, min_comp = 2,
  max_comp = 10, min_prior = 0.001, model_selection = "BIC",
  nrep = 1, niter = 1000)
}
\arguments{
\item{CN_features}{a \code{list} generate from \code{\link[=get_features]{get_features()}} function.}

\item{seed}{seed number.}

\item{min_comp}{minimal number of components to fit, default is 2.
Can also be a vector with length 6, which apply to each feature.}

\item{max_comp}{maximal number of components to fit, default is 10.
Can also be a vector with length 6, which apply to each feature.}

\item{min_prior}{minimal prior value, default is 0.001.
Details about custom setting please refer to \strong{flexmix} package.}

\item{model_selection}{model selection strategy, default is 'BIC'.
Details about custom setting please refer to \strong{flexmix} package.}

\item{nrep}{number of run times for each value of component,
keep only the solution with maximum likelihood.}

\item{niter}{maximal number of iteration to achive converge.}
}
\value{
a \code{list} contain \code{flexmix} object of copy-number features.
}
\description{
Apply mixture modelling to breakdown each feature distribution into mixtures
of Gaussian or mixtures of Poison distributions using \strong{flexmix} package. The order of
features is 'Segment size', 'Breakpoint count per 10 Mb', 'Length of oscillating copy-number chain',
'Breakpoint count per arm',  'Copy number change', 'Absolute copy number'.
}
\examples{
\donttest{
# Load copy number features
load(system.file("extdata", "toy_cn_features.RData",
  package = "sigminer", mustWork = TRUE
))
cn_components <- get_components(cn_features)
}
}
\seealso{
Other internal calculation function series: \code{\link{get_ArmLocation}},
  \code{\link{get_LengthFraction}},
  \code{\link{get_cnlist}},
  \code{\link{get_cnsummary_sample}},
  \code{\link{get_features}}, \code{\link{get_matrix}}
}
\author{
Geoffrey Macintyre, Shixiang Wang
}
\concept{internal calculation function series}
