% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{test_run_components}
\alias{test_run_components}
\title{Test running status for getting components}
\usage{
test_run_components(CN_features, feature_name = c("segsize", "bp10MB",
  "osCN", "bpchrarm", "changepoint", "copynumber"), seed = 123456,
  min_comp = 2, max_comp = 10, min_prior = 0.001,
  model_selection = "BIC", nrep = 1, niter = 1000)
}
\arguments{
\item{CN_features}{a \code{list} generate from \code{\link[=get_features]{get_features()}} function.}

\item{feature_name}{feature name to test.}

\item{seed}{seed number.}

\item{min_comp}{minimal number of components to fit, default is 2.}

\item{max_comp}{maximal number of components to fit, default is 10.}

\item{min_prior}{minimal prior value, default is 0.001.
Details about custom setting please refer to \strong{flexmix} package.}

\item{model_selection}{model selection strategy, default is 'BIC'.
Details about custom setting please refer to \strong{flexmix} package.}

\item{nrep}{number of run times for each value of component,
keep only the solution with maximum likelihood.}

\item{niter}{maximal number of iteration to achive converge.}
}
\value{
a \code{list} contain \code{flexmix} object of copy-number features.
}
\description{
This is used when user find it is hard to determine component number
by \link{get_components} function.
}
\examples{
# Load copy number features
load(system.file("extdata", "toy_cn_features.RData",
  package = "sigminer", mustWork = TRUE
))

# Test component number from 2 to 3 for feature 'sigment size'
test_run_components(cn_features, feature_name = "segsize", max_comp = 3)
}
\author{
Shixiang Wang
}
\concept{test function series}
