% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series.R
\name{get_matrix}
\alias{get_matrix}
\title{Generate a sample-by-component matrix}
\usage{
get_matrix(CN_features, all_components = NULL, cores = 1,
  rowIter = 1000)
}
\arguments{
\item{CN_features}{a \code{list} contains six copy number feature distributions,
obtain this from \code{\link[=get_features]{get_features()}} function.}

\item{all_components}{a \code{list} contain \code{flexmix} object of copy-number features, obtain this
from \link{get_components} function or use pre-compiled components data which come from CNV signature paper
https://www.nature.com/articles/s41588-018-0179-8 (set this parameter as \code{NULL}).}

\item{cores}{number of compute cores to run this task.
You can use \code{\link[parallel:detectCores]{parallel::detectCores()}} function to check how
many cores you can use.}

\item{rowIter}{step size of iteration for rows of ech CNV feature.}
}
\value{
a numeric sample-by-component \code{matrix}
}
\description{
Generate a sample-by-component matrix representing the sum of
posterior probabilities of each copy-number event being assigned to each component.
}
\examples{
# Load copy number components
load(system.file("extdata", "toy_cn_components.RData",
  package = "sigminer", mustWork = TRUE
))
# Load copy number features
load(system.file("extdata", "toy_cn_features.RData",
  package = "sigminer", mustWork = TRUE
))

cn_matrix <- get_matrix(cn_features, cn_components)
}
\seealso{
Other internal calculation function series: \code{\link{get_ArmLocation}},
  \code{\link{get_LengthFraction}},
  \code{\link{get_cnlist}},
  \code{\link{get_cnsummary_sample}},
  \code{\link{get_components}}, \code{\link{get_features}}
}
\author{
Geoffrey Macintyre, Shixiang Wang
}
\concept{internal calculation function series}
