% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature_series.R
\name{sig_get_similarity}
\alias{sig_get_similarity}
\title{Get similarity between signatures}
\usage{
sig_get_similarity(sig1, sig2, type = c("cos", "cor"))
}
\arguments{
\item{sig1}{signature 1, result of \link{sig_extract} function or
a \code{data.frame} which rows are features and columns are signatures
(colnames are necessary).}

\item{sig2}{signature 2, result of \link{sig_extract} function or
a \code{data.frame} which rows are features and columns are signatures
(colnames are necessary).}

\item{type}{could be "cos" (default, cosine similarity) or "cor" (correlation).}
}
\value{
a \code{matrix} which rownames from \code{sig1} and colnames from \code{sig2}.
}
\description{
Obtain similarity for two signature matrix, their rows (features) must match.
}
\seealso{
Other signature analysis series function: \code{\link{sig_assign_samples}},
  \code{\link{sig_estimate}}, \code{\link{sig_extract}},
  \code{\link{sig_get_activity}},
  \code{\link{sig_get_correlation}},
  \code{\link{sig_prepare}},
  \code{\link{sig_summarize_subtypes}}
}
\author{
Shixiang Wang
}
\concept{signature analysis series function}
