% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_groups.R
\name{get_groups}
\alias{get_groups}
\title{Get Sample Groups from Signature Decomposition Information}
\usage{
get_groups(
  Signature,
  method = c("consensus", "k-means", "exposure", "samples"),
  n_cluster = NULL,
  match_consensus = TRUE
)
}
\arguments{
\item{Signature}{a \code{Signature} object obtained either from \link{sig_extract} or \link{sig_auto_extract}.
Now it can be used to relative exposure result in \code{data.table} format from \link{sig_fit}.}

\item{method}{grouping method, more see details, could be one of the following:
\itemize{
\item 'consensus' - returns the cluster membership based on the hierarchical clustering of the consensus matrix,
it can only be used for the result obtained by \code{\link[=sig_extract]{sig_extract()}} with multiple runs using \strong{NMF} package.
\item 'k-means' -  returns the clusters by k-means.
\item 'exposure' - assigns a sample into a group whose signature exposure
is dominant.
\item 'samples' - returns the cluster membership based on the contribution of signature to each sample,
it can only be used for the result obtained by \code{\link[=sig_extract]{sig_extract()}} using \strong{NMF} package.
}}

\item{n_cluster}{only used when the \code{method} is 'k-means'.}

\item{match_consensus}{only used when the \code{method} is 'consensus'.
If \code{TRUE}, the result will match order as shown in consensus map.}
}
\value{
a \code{data.table} object
}
\description{
One of key results from signature analysis is to cluster samples into different
groups. This function takes \code{Signature} object as input
and return the membership in each cluster.
}
\details{
Users may find there are bigger differences between using method 'samples' and 'exposure' but
they use a similar idear to find dominant signature, here goes the reason:

Method 'samples' using data directly from NMF decomposition, this means the two matrix
\code{W} (basis matrix or signature matrix) and \code{H} (coefficient matrix or exposure matrix) are
the results of NMF. For method 'exposure', it uses the signature exposure loading matrix.
In this situation, each signture represents a number of mutations (alterations)
about implementation please see source code of \code{\link[=sig_extract]{sig_extract()}} function.
}
\examples{
\donttest{
# Load copy number prepare object
load(system.file("extdata", "toy_copynumber_tally_W.RData",
  package = "sigminer", mustWork = TRUE
))
# Extract copy number signatures
library(NMF)
sig <- sig_extract(cn_tally_W$nmf_matrix, 2,
  nrun = 10,
  pConstant = 1e-13
)

# Methods 'consensus' and 'samples' are from NMF::predict()
get_groups(sig, method = "consensus", match_consensus = TRUE)
get_groups(sig, method = "samples")

# Use k-means clustering
get_groups(sig, method = "k-means")
}
}
\seealso{
\code{\link[NMF:predict]{NMF::predict()}}, \link{show_groups}.
}
